/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import com.netflix.appinfo.InstanceInfo;
import de.codecentric.boot.admin.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.model.Application;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClient;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EurekaServiceInstanceConverter
implements ServiceInstanceConverter {
    @Override
    public Application convert(ServiceInstance instance) {
        Assert.isInstanceOf(EurekaDiscoveryClient.EurekaServiceInstance.class, (Object)instance, (String)"serviceInstance must be of type EurekaServiceInstance");
        return this.convert(((EurekaDiscoveryClient.EurekaServiceInstance)instance).getInstanceInfo());
    }

    private Application convert(InstanceInfo instanceInfo) {
        String mgmtUrl = instanceInfo.getHomePageUrl();
        String mgmtPath = (String)instanceInfo.getMetadata().get("management.context-path");
        if (StringUtils.hasText((String)mgmtPath)) {
            mgmtUrl = this.append(mgmtUrl, mgmtPath);
        }
        return Application.create((String)instanceInfo.getAppName()).withHealthUrl(instanceInfo.getHealthCheckUrl()).withManagementUrl(mgmtUrl).withServiceUrl(instanceInfo.getHomePageUrl()).build();
    }

    private String append(String mgmtUrl, String mgmtPath) {
        if (mgmtUrl.endsWith("/")) {
            mgmtUrl = mgmtUrl.substring(0, mgmtUrl.length() - 1);
        }
        if (!mgmtPath.startsWith("/")) {
            mgmtPath = "/" + mgmtPath;
        }
        return mgmtUrl + mgmtPath;
    }
}

