/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.codecentric.boot.admin.model.Info;
import de.codecentric.boot.admin.model.StatusInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

@JsonDeserialize(using=Deserializer.class)
public class Application
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String id;
    private final String name;
    private final String managementUrl;
    private final String healthUrl;
    private final String serviceUrl;
    private final StatusInfo statusInfo;
    private final String source;
    @JsonSerialize(using=MetadataSerializer.class)
    private final Map<String, String> metadata;
    private final Info info;

    protected Application(Builder builder) {
        Assert.hasText((String)builder.name, (String)"name must not be empty!");
        Assert.hasText((String)builder.healthUrl, (String)"healthUrl must not be empty!");
        Assert.notNull((Object)builder.statusInfo, (String)"statusInfo must not be null!");
        this.healthUrl = builder.healthUrl;
        this.managementUrl = builder.managementUrl;
        this.serviceUrl = builder.serviceUrl;
        this.name = builder.name;
        this.id = builder.id;
        this.statusInfo = builder.statusInfo;
        this.source = builder.source;
        this.metadata = Collections.unmodifiableMap(new HashMap(builder.metadata));
        this.info = builder.info;
    }

    public static Builder create(String name) {
        return new Builder(name);
    }

    public static Builder copyOf(Application application) {
        return new Builder(application);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getManagementUrl() {
        return this.managementUrl;
    }

    public String getHealthUrl() {
        return this.healthUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Info getInfo() {
        return this.info;
    }

    public String toString() {
        return "Application [id=" + this.id + ", name=" + this.name + ", managementUrl=" + this.managementUrl + ", healthUrl=" + this.healthUrl + ", serviceUrl=" + this.serviceUrl + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.healthUrl == null ? 0 : this.healthUrl.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.managementUrl == null ? 0 : this.managementUrl.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Application other = (Application)obj;
        if (this.healthUrl == null ? other.healthUrl != null : !this.healthUrl.equals(other.healthUrl)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.managementUrl == null ? other.managementUrl != null : !this.managementUrl.equals(other.managementUrl)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }

    public static class MetadataSerializer
    extends StdSerializer<Map<String, String>> {
        private static final long serialVersionUID = 1L;
        private static Pattern[] keysToSanitize = MetadataSerializer.createPatterns(".*password$", ".*secret$", ".*key$", ".*$token$", ".*credentials.*", ".*vcap_services$");

        public MetadataSerializer() {
            super(Map.class);
        }

        private static Pattern[] createPatterns(String ... keys) {
            Pattern[] patterns = new Pattern[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                patterns[i] = Pattern.compile(keys[i]);
            }
            return patterns;
        }

        public void serialize(Map<String, String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            for (Map.Entry<String, String> entry : value.entrySet()) {
                gen.writeStringField(entry.getKey(), this.sanitize(entry.getKey(), entry.getValue()));
            }
            gen.writeEndObject();
        }

        private String sanitize(String key, String value) {
            for (Pattern pattern : keysToSanitize) {
                if (!pattern.matcher(key).matches()) continue;
                return value == null ? null : "******";
            }
            return value;
        }
    }

    public static class Deserializer
    extends StdDeserializer<Application> {
        private static final long serialVersionUID = 1L;

        protected Deserializer() {
            super(Application.class);
        }

        public Application deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.readValueAsTree();
            Builder builder = Application.create(node.get("name").asText());
            if (node.has("url")) {
                String url = node.get("url").asText();
                builder.withHealthUrl(url.replaceFirst("/+$", "") + "/health").withManagementUrl(url);
            } else {
                if (node.has("healthUrl")) {
                    builder.withHealthUrl(node.get("healthUrl").asText());
                }
                if (node.has("managementUrl")) {
                    builder.withManagementUrl(node.get("managementUrl").asText());
                }
                if (node.has("serviceUrl")) {
                    builder.withServiceUrl(node.get("serviceUrl").asText());
                }
            }
            if (node.has("metadata")) {
                Iterator it = node.get("metadata").fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    builder.addMetadata((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                }
            }
            return builder.build();
        }
    }

    public static class Builder {
        private String id;
        private String name;
        private String managementUrl;
        private String healthUrl;
        private String serviceUrl;
        private StatusInfo statusInfo = StatusInfo.ofUnknown();
        private String source;
        private Map<String, String> metadata = new HashMap<String, String>();
        private Info info = Info.empty();

        private Builder(String name) {
            this.name = name;
        }

        private Builder(Application application) {
            this.healthUrl = application.healthUrl;
            this.managementUrl = application.managementUrl;
            this.serviceUrl = application.serviceUrl;
            this.name = application.name;
            this.id = application.id;
            this.statusInfo = application.statusInfo;
            this.source = application.source;
            this.metadata.putAll(application.getMetadata());
            this.info = application.info;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public Builder withHealthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
            return this;
        }

        public Builder withManagementUrl(String managementUrl) {
            this.managementUrl = managementUrl;
            return this;
        }

        public Builder withStatusInfo(StatusInfo statusInfo) {
            this.statusInfo = statusInfo;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withInfo(Info info) {
            this.info = info;
            return this;
        }

        public Application build() {
            return new Application(this);
        }
    }
}

