/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.entities;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.BuildVersion;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;

public final class Application {
    private final String name;
    @Nullable
    private final BuildVersion buildVersion;
    private final String status;
    private final Instant statusTimestamp;
    private final List<Instance> instances;

    private Application(String name, @Nullable BuildVersion buildVersion, @Nullable String status, @Nullable Instant statusTimestamp, List<Instance> instances) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        this.name = name;
        this.buildVersion = buildVersion;
        this.status = status != null ? status : "UNKNOWN";
        this.statusTimestamp = statusTimestamp != null ? statusTimestamp : Instant.now();
        this.instances = instances.isEmpty() ? Collections.emptyList() : new ArrayList<Instance>(instances);
    }

    public static Builder create(String name) {
        return Application.builder().name(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).buildVersion(this.buildVersion).status(this.status).statusTimestamp(this.statusTimestamp).instances(this.instances);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public BuildVersion getBuildVersion() {
        return this.buildVersion;
    }

    public String getStatus() {
        return this.status;
    }

    public Instant getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BuildVersion this$buildVersion = this.getBuildVersion();
        BuildVersion other$buildVersion = other.getBuildVersion();
        if (this$buildVersion == null ? other$buildVersion != null : !((Object)this$buildVersion).equals(other$buildVersion)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Instant this$statusTimestamp = this.getStatusTimestamp();
        Instant other$statusTimestamp = other.getStatusTimestamp();
        if (this$statusTimestamp == null ? other$statusTimestamp != null : !((Object)this$statusTimestamp).equals(other$statusTimestamp)) {
            return false;
        }
        List<Instance> this$instances = this.getInstances();
        List<Instance> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BuildVersion $buildVersion = this.getBuildVersion();
        result = result * 59 + ($buildVersion == null ? 43 : ((Object)$buildVersion).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Instant $statusTimestamp = this.getStatusTimestamp();
        result = result * 59 + ($statusTimestamp == null ? 43 : ((Object)$statusTimestamp).hashCode());
        List<Instance> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        return result;
    }

    public String toString() {
        return "Application(name=" + this.getName() + ", buildVersion=" + this.getBuildVersion() + ", status=" + this.getStatus() + ", statusTimestamp=" + this.getStatusTimestamp() + ", instances=" + this.getInstances() + ")";
    }

    public static class Builder {
        private String name;
        private BuildVersion buildVersion;
        private String status;
        private Instant statusTimestamp;
        private List<Instance> instances;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder buildVersion(@Nullable BuildVersion buildVersion) {
            this.buildVersion = buildVersion;
            return this;
        }

        public Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public Builder statusTimestamp(@Nullable Instant statusTimestamp) {
            this.statusTimestamp = statusTimestamp;
            return this;
        }

        public Builder instances(List<Instance> instances) {
            this.instances = instances;
            return this;
        }

        public Application build() {
            return new Application(this.name, this.buildVersion, this.status, this.statusTimestamp, this.instances);
        }

        public String toString() {
            return "Application.Builder(name=" + this.name + ", buildVersion=" + this.buildVersion + ", status=" + this.status + ", statusTimestamp=" + this.statusTimestamp + ", instances=" + this.instances + ")";
        }
    }
}

