/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.services.ApplicationRegistrator;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class RegistrationApplicationListener {
    private final ApplicationRegistrator registrator;
    private boolean autoDeregister = false;
    private final TaskExecutor executor;

    public RegistrationApplicationListener(ApplicationRegistrator registrator, TaskExecutor executor) {
        this.registrator = registrator;
        this.executor = executor;
    }

    public RegistrationApplicationListener(ApplicationRegistrator registrator) {
        this(registrator, (TaskExecutor)new SimpleAsyncTaskExecutor());
    }

    @EventListener
    @Order(value=0x7FFFFFFF)
    public void onApplicationReady(ApplicationReadyEvent event) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                RegistrationApplicationListener.this.registrator.register();
            }
        });
    }

    @EventListener
    @Order(value=0x7FFFFFFF)
    public void onClosedContext(ContextClosedEvent event) {
        if (this.autoDeregister) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    RegistrationApplicationListener.this.registrator.deregister();
                }
            });
        }
    }

    public void setAutoDeregister(boolean autoDeregister) {
        this.autoDeregister = autoDeregister;
    }

    public boolean isAutoDeregister() {
        return this.autoDeregister;
    }
}

