/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web;

import com.fasterxml.jackson.core.Base64Variants;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class BasicAuthHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final String encodedAuth;

    public BasicAuthHttpRequestInterceptor(String username, String password) {
        String auth = username + ":" + password;
        this.encodedAuth = "Basic " + Base64Variants.MIME_NO_LINEFEEDS.encode(auth.getBytes(StandardCharsets.US_ASCII));
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        request.getHeaders().add("Authorization", this.encodedAuth);
        return execution.execute(request, body);
    }
}

