/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Net {
    private final String bindIp;
    private final int port;
    private final boolean ipv6;

    public Net() throws IOException {
        this(null, Network.getFreeServerPort(), Network.localhostIsIPv6());
    }

    public Net(int port, boolean ipv6) {
        this(null, port, ipv6);
    }

    public Net(String bindIp, int port, boolean ipv6) {
        this.bindIp = bindIp;
        this.port = port;
        this.ipv6 = ipv6;
    }

    public String getBindIp() {
        return this.bindIp;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isIpv6() {
        return this.ipv6;
    }

    public InetAddress getServerAddress() throws UnknownHostException {
        if (this.bindIp != null) {
            return InetAddress.getByName(this.bindIp);
        }
        return Network.getLocalHost();
    }

    public static Net defaults() {
        try {
            return new Net();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

