/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.file;

import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.FileAlreadyExistsException;
import de.flapdoodle.embed.process.io.file.FileCleaner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files {
    private static Logger logger = LoggerFactory.getLogger(Files.class);
    public static final int BYTE_BUFFER_LENGTH = 16384;
    private static final SimpleFileVisitor<Path> DELETE_DIR_VISITOR = new DeleteDirVisitor();

    private Files() {
    }

    @Deprecated
    public static File createTempFile(String tempFileName) throws IOException {
        return Files.createTempFile(PropertyOrPlatformTempDir.defaultInstance(), tempFileName);
    }

    public static File createTempFile(IDirectory directory, String tempFileName) throws IOException {
        File tempDir = directory.asFile();
        return Files.createTempFile(tempDir, tempFileName);
    }

    public static File createTempFile(File tempDir, String tempFileName) throws IOException, FileAlreadyExistsException {
        File tempFile = Files.fileOf(tempDir, tempFileName);
        Files.createOrCheckDir(tempFile.getParentFile());
        if (!tempFile.createNewFile()) {
            throw new FileAlreadyExistsException("could not create", tempFile);
        }
        return tempFile;
    }

    public static File createOrCheckDir(String dir) throws IOException {
        File tempFile = new File(dir);
        return Files.createOrCheckDir(tempFile);
    }

    public static File createOrCheckDir(File dir) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        return Files.createDir(dir);
    }

    public static File createOrCheckUserDir(String prefix) throws IOException {
        File tempDir = new File(System.getProperty("user.home"));
        File tempFile = new File(tempDir, prefix);
        return Files.createOrCheckDir(tempFile);
    }

    @Deprecated
    public static File createTempDir(String prefix) throws IOException {
        return Files.createTempDir(PropertyOrPlatformTempDir.defaultInstance(), prefix);
    }

    public static File createTempDir(IDirectory directory, String prefix) throws IOException {
        File tempDir = directory.asFile();
        return Files.createTempDir(tempDir, prefix);
    }

    public static File createTempDir(File tempDir, String prefix) throws IOException {
        File tempFile = new File(tempDir, prefix + "-" + UUID.randomUUID().toString());
        return Files.createDir(tempFile);
    }

    public static File createDir(File tempFile) throws IOException {
        if (!tempFile.mkdirs()) {
            throw new IOException("could not create dirs: " + tempFile);
        }
        return tempFile;
    }

    public static boolean forceDelete(File fileOrDir) {
        boolean ret = false;
        try {
            if (fileOrDir != null && fileOrDir.exists()) {
                Files.forceDelete(fileOrDir.toPath());
                logger.debug("could delete {}", (Object)fileOrDir);
                ret = true;
            }
        }
        catch (IOException e) {
            logger.warn("could not delete {}. Will try to delete it again when program exits.", (Object)fileOrDir);
            FileCleaner.forceDeleteOnExit(fileOrDir);
            ret = true;
        }
        return ret;
    }

    public static void forceDelete(Path path) throws IOException {
        if (!java.nio.file.Files.isDirectory(path, new LinkOption[0])) {
            java.nio.file.Files.delete(path);
        } else {
            java.nio.file.Files.walkFileTree(path, DeleteDirVisitor.getInstance());
        }
    }

    public static void write(InputStream in, long size, File output) throws IOException {
        try (OutputStream out = java.nio.file.Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            int read;
            byte[] buf = new byte[16384];
            int left = buf.length;
            if ((long)left > size) {
                left = (int)size;
            }
            while ((read = in.read(buf, 0, left)) > 0) {
                out.write(buf, 0, read);
                if ((long)left <= (size -= (long)read)) continue;
                left = (int)size;
            }
        }
    }

    public static void write(InputStream in, File output) throws IOException {
        java.nio.file.Files.copy(in, output.toPath(), new CopyOption[0]);
    }

    public static void write(String content, File output) throws IOException {
        java.nio.file.Files.write(output.toPath(), content.getBytes(), new OpenOption[0]);
    }

    public static boolean moveFile(File source, File destination) {
        try {
            java.nio.file.Files.move(source.toPath(), destination.toPath(), new CopyOption[0]);
            return true;
        }
        catch (IOException iox) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File destination) throws IOException {
        FileInputStream reader = null;
        FileOutputStream writer = null;
        try {
            int read;
            reader = new FileInputStream(source);
            writer = new FileOutputStream(destination);
            byte[] buf = new byte[16384];
            while ((read = reader.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static File fileOf(File base, File relative) {
        return base.toPath().resolve(relative.toPath()).toFile();
    }

    public static File fileOf(File base, String relative) {
        return base.toPath().resolve(relative).toFile();
    }

    private static class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteDirVisitor() {
        }

        public static SimpleFileVisitor<Path> getInstance() {
            return DELETE_DIR_VISITOR;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            java.nio.file.Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            java.nio.file.Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

