/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json;

import com.google.gson.GsonBuilder;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.gerdiproject.json.datacite.Date;
import de.gerdiproject.json.datacite.DateRange;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.adapters.DataCiteExtensionsAdapter;
import de.gerdiproject.json.datacite.adapters.DateAdapter;
import de.gerdiproject.json.datacite.adapters.FunderIdentifierTypeAdapter;
import de.gerdiproject.json.datacite.enums.FunderIdentifierType;
import de.gerdiproject.json.datacite.extension.DataCiteExtensions;
import de.gerdiproject.json.datacite.extension.adapters.SoepDataCiteExtensionAdapter;
import de.gerdiproject.json.datacite.extension.generic.AbstractResearch;
import de.gerdiproject.json.datacite.extension.generic.ResearchArea;
import de.gerdiproject.json.datacite.extension.generic.ResearchDiscipline;
import de.gerdiproject.json.datacite.extension.generic.adapter.ResearchAdapter;
import de.gerdiproject.json.datacite.extension.soep.SoepDataCiteExtension;
import de.gerdiproject.json.geo.adapters.GeometryAdapter;
import de.gerdiproject.json.geo.adapters.LineStringAdapter;
import de.gerdiproject.json.geo.adapters.MultiLineStringAdapter;
import de.gerdiproject.json.geo.adapters.MultiPointAdapter;
import de.gerdiproject.json.geo.adapters.MultiPolygonAdapter;
import de.gerdiproject.json.geo.adapters.PointAdapter;
import de.gerdiproject.json.geo.adapters.PolygonAdapter;

public final class GsonUtils {
    public static GsonBuilder createGerdiDocumentGsonBuilder() {
        return GsonUtils.createGerdiDocumentGsonBuilder(GsonUtils.createGeoJsonGsonBuilder());
    }

    public static GsonBuilder createGerdiDocumentGsonBuilder(int geoDecimalPlaces) {
        return GsonUtils.createGerdiDocumentGsonBuilder(GsonUtils.createGeoJsonGsonBuilder(geoDecimalPlaces));
    }

    public static GsonBuilder createGeoJsonGsonBuilder() {
        return GsonUtils.createGeoJsonGsonBuilder(new GeometryFactory());
    }

    public static GsonBuilder createGeoJsonGsonBuilder(int decimalPlaces) {
        if (decimalPlaces <= 0) {
            throw new IllegalArgumentException("The number of decimal places must be greater than zero!");
        }
        double precision = Math.pow(10.0, decimalPlaces - 1);
        return GsonUtils.createGeoJsonGsonBuilder(new GeometryFactory(new PrecisionModel(precision)));
    }

    private static GsonBuilder createGerdiDocumentGsonBuilder(GsonBuilder geoJsonBuilder) {
        return geoJsonBuilder.registerTypeAdapter(AbstractDate.class, (Object)new DateAdapter()).registerTypeAdapter(FunderIdentifierType.class, (Object)new FunderIdentifierTypeAdapter()).registerTypeAdapter(DateRange.class, (Object)new DateAdapter()).registerTypeAdapter(Date.class, (Object)new DateAdapter()).registerTypeAdapter(AbstractResearch.class, (Object)new ResearchAdapter()).registerTypeAdapter(ResearchArea.class, (Object)new ResearchAdapter()).registerTypeAdapter(ResearchDiscipline.class, (Object)new ResearchAdapter()).registerTypeAdapter(DataCiteExtensions.class, (Object)new DataCiteExtensionsAdapter()).registerTypeAdapter(SoepDataCiteExtension.class, (Object)new SoepDataCiteExtensionAdapter());
    }

    private static GsonBuilder createGeoJsonGsonBuilder(GeometryFactory geoFactory) {
        return new GsonBuilder().registerTypeAdapter(Geometry.class, (Object)new GeometryAdapter()).registerTypeAdapter(Point.class, (Object)new PointAdapter(geoFactory)).registerTypeAdapter(MultiPoint.class, (Object)new MultiPointAdapter(geoFactory)).registerTypeAdapter(LineString.class, (Object)new LineStringAdapter(geoFactory)).registerTypeAdapter(MultiLineString.class, (Object)new MultiLineStringAdapter(geoFactory)).registerTypeAdapter(Polygon.class, (Object)new PolygonAdapter(geoFactory)).registerTypeAdapter(MultiPolygon.class, (Object)new MultiPolygonAdapter(geoFactory));
    }

    private GsonUtils() {
    }
}

