/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.constants;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class DataCiteDateConstants {
    public static final String PARSE_ERROR = "Could not parse date string '%s'!";
    public static final String DATE_RANGE_SPLITTER = "/";
    public static final String DATE_RANGE_FORMAT = "%s/%s";
    public static final String VALUE_JSON = "value";
    public static final String DATE_TYPE_JSON = "dateType";
    public static final String DATE_INFO_JSON = "dateInformation";
    public static final String DATE_SPLIT_REGEX = "[\\-/,;. \\\\]+";
    public static final DateTimeFormatter MONTH_FORMATTER = DataCiteDateConstants.initMonthFormatter();
    public static final DateTimeFormatter ISO8601_FORMATTER = DataCiteDateConstants.initIso8601Formatter();
    public static final Pattern NUMBERS_PATTERN = Pattern.compile("(\\d{1,})");
    public static final String STANDARD_TIMEZONE = "UTC";
    public static final ZoneId Z_ZONE_ID = ZoneId.of("Z");
    public static final List<String> DATE_RANGE_SEPARATORS = Collections.unmodifiableList(Arrays.asList("/", "-", "until", "to"));

    private static DateTimeFormatter initIso8601Formatter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.parseCaseInsensitive();
        builder.parseLenient();
        builder.appendPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSS]][X]");
        return builder.toFormatter().withZone(ZoneId.of(STANDARD_TIMEZONE));
    }

    private static DateTimeFormatter initMonthFormatter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.appendPattern("[MMMM][MMM]");
        builder.parseCaseInsensitive();
        builder.parseLenient();
        return builder.toFormatter().withZone(ZoneId.of(STANDARD_TIMEZONE)).withLocale(Locale.ENGLISH);
    }

    private DataCiteDateConstants() {
    }
}

