/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.extension.generic.constants;

import de.gerdiproject.json.datacite.extension.generic.ResearchArea;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResearchAreaConstants {
    public static final ResearchArea ANCIENT_CULTURES = new ResearchArea(101, "Ancient Cultures", "Humanities and Social Sciences");
    public static final ResearchArea HISTORY = new ResearchArea(102, "History", "Humanities and Social Sciences");
    public static final ResearchArea FINE_ARTS = new ResearchArea(103, "Fine Arts, Music, Theatre and Media Studies", "Humanities and Social Sciences");
    public static final ResearchArea LINGUISTICS = new ResearchArea(104, "Linguistics", "Humanities and Social Sciences");
    public static final ResearchArea LITERARY_STUDIES = new ResearchArea(105, "Literary Studies", "Humanities and Social Sciences");
    public static final ResearchArea SOCIAL_AND_CULTURAL_ANTHROPOLOGY = new ResearchArea(106, "Social and Cultural Anthropology, Non-European Cultures, Jewish Studies and Religious Studies", "Humanities and Social Sciences");
    public static final ResearchArea THEOLOGY = new ResearchArea(107, "Theology", "Humanities and Social Sciences");
    public static final ResearchArea PHILOSOPHY = new ResearchArea(108, "Philosophy", "Humanities and Social Sciences");
    public static final ResearchArea EDUCATIONAL_RESEARCH = new ResearchArea(109, "Educational Research", "Humanities and Social Sciences");
    public static final ResearchArea PSYCHOLOGY = new ResearchArea(110, "Psychology", "Humanities and Social Sciences");
    public static final ResearchArea SOCIAL_SCIENCES = new ResearchArea(111, "Social Sciences", "Humanities and Social Sciences");
    public static final ResearchArea ECONOMICS = new ResearchArea(112, "Economics", "Humanities and Social Sciences");
    public static final ResearchArea JURISPRUDENCE = new ResearchArea(113, "Jurisprudence", "Humanities and Social Sciences");
    public static final ResearchArea BASIC_RESEARCH_IN_BIOLOGY_AND_MEDICINE = new ResearchArea(201, "Basic Research in Biology and Medicine", "Life Sciences");
    public static final ResearchArea PLANT_SCIENCES = new ResearchArea(202, "Plant Sciences", "Life Sciences");
    public static final ResearchArea ZOOLOGY = new ResearchArea(203, "Zoology", "Life Sciences");
    public static final ResearchArea MICROBIOLOGY = new ResearchArea(204, "Microbiology, Virology and Immunology", "Life Sciences");
    public static final ResearchArea MEDICINE = new ResearchArea(205, "Medicine", "Life Sciences");
    public static final ResearchArea NEUROSCIENCES = new ResearchArea(206, "Neurosciences", "Life Sciences");
    public static final ResearchArea AGRICULTURE = new ResearchArea(207, "Agriculture, Forestry and Veterinary Medicine", "Life Sciences");
    public static final ResearchArea MOLECULAR_CHEMISTRY = new ResearchArea(301, "Molecular Chemistry", "Natural Sciences");
    public static final ResearchArea CHEMICAL_SOLID_STATE_AND_SURFACE_RESEARCH = new ResearchArea(302, "Chemical Solid State and Surface Research", "Natural Sciences");
    public static final ResearchArea PHYSICAL_AND_THEORETICAL_CHEMISTRY = new ResearchArea(303, "Physical and Theoretical Chemistry", "Natural Sciences");
    public static final ResearchArea ANALYTICAL_CHEMISTRY = new ResearchArea(304, "Analytical Chemistry, Method Development (Chemistry)", "Natural Sciences");
    public static final ResearchArea BIOLOGICAL_CHEMISTRY_AND_FOOD_CHEMISTRY = new ResearchArea(305, "Biological Chemistry and Food Chemistry", "Natural Sciences");
    public static final ResearchArea POLYMER_RESEARCH = new ResearchArea(306, "Polymer Research", "Natural Sciences");
    public static final ResearchArea CONDENSED_MATTER_PHYSICS = new ResearchArea(307, "Condensed Matter Physics", "Natural Sciences");
    public static final ResearchArea OPTICS = new ResearchArea(308, "Optics, Quantum Optics and Physics of Atoms, Molecules and Plasmas", "Natural Sciences");
    public static final ResearchArea PARTICLES = new ResearchArea(309, "Particles, Nuclei and Fields", "Natural Sciences");
    public static final ResearchArea STATISTICAL_PHYSICS = new ResearchArea(310, "Statistical Physics, Soft Matter, Biological Physics, Nonlinear Dynamics", "Natural Sciences");
    public static final ResearchArea ASTROPHYSICS_AND_ASTRONOMY = new ResearchArea(311, "Astrophysics and Astronomy", "Natural Sciences");
    public static final ResearchArea MATHEMATICS = new ResearchArea(312, "Mathematics", "Natural Sciences");
    public static final ResearchArea ATMOSPHERIC_SCIENCE = new ResearchArea(313, "Atmospheric Science, Oceanography and Climate Research", "Natural Sciences");
    public static final ResearchArea GEOLOGY_AND_PALAEONTOLOGY = new ResearchArea(314, "Geology and Palaeontology", "Natural Sciences");
    public static final ResearchArea GEOPHYSICS_AND_GEODESY = new ResearchArea(315, "Geophysics and Geodesy", "Natural Sciences");
    public static final ResearchArea GEOCHEMISTRY = new ResearchArea(316, "Geochemistry, Mineralogy and Crystallography", "Natural Sciences");
    public static final ResearchArea GEOGRAPHY = new ResearchArea(317, "Geography", "Natural Sciences");
    public static final ResearchArea WATER_RESEARCH = new ResearchArea(318, "Water Research", "Natural Sciences");
    public static final ResearchArea PRODUCTION_TECHNOLOGY = new ResearchArea(401, "Production Technology", "Engineering Sciences");
    public static final ResearchArea MECHANICS_AND_CONSTRUCTIVE_MECHANICAL_ENGINEERING = new ResearchArea(402, "Mechanics and Constructive Mechanical Engineering", "Engineering Sciences");
    public static final ResearchArea PROCESS_ENGINEERING = new ResearchArea(403, "Process Engineering, Technical Chemistry", "Engineering Sciences");
    public static final ResearchArea HEAT_ENERGY_TECHNOLOGY = new ResearchArea(404, "Heat Energy Technology, Thermal Machines, Fluid Mechanics", "Engineering Sciences");
    public static final ResearchArea MATERIALS_ENGINEERING = new ResearchArea(405, "Materials Engineering", "Engineering Sciences");
    public static final ResearchArea MATERIALS_SCIENCE = new ResearchArea(406, "Materials Science", "Engineering Sciences");
    public static final ResearchArea SYSTEMS_ENGINEERING = new ResearchArea(407, "Systems Engineering", "Engineering Sciences");
    public static final ResearchArea ELECTRICAL_ENGINEERING_AND_INFORMATION_TECHNOLOGY = new ResearchArea(408, "Electrical Engineering and Information Technology", "Engineering Sciences");
    public static final ResearchArea COMPUTER_SCIENCE = new ResearchArea(409, "Computer Science", "Engineering Sciences");
    public static final ResearchArea CONSTRUCTION_ENGINEERING_AND_ARCHITECTURE = new ResearchArea(410, "Construction Engineering and Architecture", "Engineering Sciences");
    private static final Map<Integer, ResearchArea> RESEARCH_MAP = ResearchAreaConstants.createResearchMap(ANCIENT_CULTURES, HISTORY, FINE_ARTS, LINGUISTICS, LITERARY_STUDIES, SOCIAL_AND_CULTURAL_ANTHROPOLOGY, THEOLOGY, PHILOSOPHY, EDUCATIONAL_RESEARCH, PSYCHOLOGY, SOCIAL_SCIENCES, ECONOMICS, JURISPRUDENCE, BASIC_RESEARCH_IN_BIOLOGY_AND_MEDICINE, PLANT_SCIENCES, ZOOLOGY, MICROBIOLOGY, MEDICINE, NEUROSCIENCES, AGRICULTURE, MOLECULAR_CHEMISTRY, CHEMICAL_SOLID_STATE_AND_SURFACE_RESEARCH, PHYSICAL_AND_THEORETICAL_CHEMISTRY, ANALYTICAL_CHEMISTRY, BIOLOGICAL_CHEMISTRY_AND_FOOD_CHEMISTRY, POLYMER_RESEARCH, CONDENSED_MATTER_PHYSICS, OPTICS, PARTICLES, STATISTICAL_PHYSICS, ASTROPHYSICS_AND_ASTRONOMY, MATHEMATICS, ATMOSPHERIC_SCIENCE, GEOLOGY_AND_PALAEONTOLOGY, GEOPHYSICS_AND_GEODESY, GEOCHEMISTRY, GEOGRAPHY, WATER_RESEARCH, PRODUCTION_TECHNOLOGY, MECHANICS_AND_CONSTRUCTIVE_MECHANICAL_ENGINEERING, PROCESS_ENGINEERING, HEAT_ENERGY_TECHNOLOGY, MATERIALS_ENGINEERING, MATERIALS_SCIENCE, SYSTEMS_ENGINEERING, ELECTRICAL_ENGINEERING_AND_INFORMATION_TECHNOLOGY, COMPUTER_SCIENCE, CONSTRUCTION_ENGINEERING_AND_ARCHITECTURE);

    public static ResearchArea getByRnbrString(String rnbrString) {
        int rnbr = Integer.parseInt(rnbrString);
        return RESEARCH_MAP.get(rnbr);
    }

    private static Map<Integer, ResearchArea> createResearchMap(ResearchArea ... areas) {
        HashMap<Integer, ResearchArea> map = new HashMap<Integer, ResearchArea>();
        for (ResearchArea ra : areas) {
            map.put(ra.getRbnr(), ra);
        }
        return Collections.unmodifiableMap(map);
    }

    private ResearchAreaConstants() {
    }
}

