/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractGeometryAdapter<T extends Geometry>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final String geometryType;
    private final double decimalFactor;
    private final GeometryFactory geoFactory;

    public AbstractGeometryAdapter(GeometryFactory geoFactory) {
        this.geoFactory = geoFactory;
        this.geometryType = ((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getSimpleName();
        this.decimalFactor = geoFactory.getPrecisionModel().getType() == PrecisionModel.FIXED ? geoFactory.getPrecisionModel().getScale() * 10.0 : Double.POSITIVE_INFINITY;
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray coordinates = this.serializeCoordinates(src);
        if (coordinates == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject out = new JsonObject();
        out.addProperty("type", this.geometryType);
        out.add("coordinates", (JsonElement)coordinates);
        return out;
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray coordinates;
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement coordinatesEle = jsonObject.get("coordinates");
        JsonArray jsonArray = coordinates = coordinatesEle.isJsonNull() ? null : coordinatesEle.getAsJsonArray();
        if (coordinates == null || coordinates.size() == 0) {
            return null;
        }
        return this.deserializeGeometry(coordinates, this.geoFactory);
    }

    protected abstract T deserializeGeometry(JsonArray var1, GeometryFactory var2);

    protected abstract JsonArray serializeCoordinates(T var1);

    protected JsonArray coordinatesToJsonArray(Coordinate ... coordinates) {
        if (coordinates == null) {
            return null;
        }
        JsonArray jsonArray = new JsonArray();
        for (Coordinate c : coordinates) {
            JsonArray coordinateJson = this.coordinateToJsonArray(c);
            if (coordinateJson == null) continue;
            jsonArray.add((JsonElement)this.coordinateToJsonArray(c));
        }
        return jsonArray;
    }

    protected JsonArray coordinateToJsonArray(Coordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        JsonArray jsonArray = new JsonArray();
        if (this.decimalFactor == Double.POSITIVE_INFINITY) {
            jsonArray.add((Number)coordinate.x);
            jsonArray.add((Number)coordinate.y);
            if (Double.isFinite(coordinate.z)) {
                jsonArray.add((Number)coordinate.z);
            }
        } else {
            jsonArray.add((Number)((double)Math.round(coordinate.x * this.decimalFactor) / this.decimalFactor));
            jsonArray.add((Number)((double)Math.round(coordinate.y * this.decimalFactor) / this.decimalFactor));
            if (Double.isFinite(coordinate.z)) {
                jsonArray.add((Number)((double)Math.round(coordinate.z * this.decimalFactor) / this.decimalFactor));
            }
        }
        return jsonArray;
    }

    protected Coordinate jsonArrayToCoordinate(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray.size() < 2) {
            return null;
        }
        double x = jsonArray.get(0).getAsDouble();
        double y = jsonArray.get(1).getAsDouble();
        if (this.decimalFactor != Double.POSITIVE_INFINITY) {
            x = (double)Math.round(x * this.decimalFactor) / this.decimalFactor;
            y = (double)Math.round(y * this.decimalFactor) / this.decimalFactor;
        }
        if (jsonArray.size() >= 3) {
            double z = jsonArray.get(2).getAsDouble();
            if (this.decimalFactor != Double.POSITIVE_INFINITY) {
                z = (double)Math.round(z * this.decimalFactor) / this.decimalFactor;
            }
            return new Coordinate(x, y, z);
        }
        return new Coordinate(x, y);
    }

    protected Coordinate[] jsonArrayToCoordinates(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        int size = jsonArray.size();
        Coordinate[] coordinates = new Coordinate[size];
        int i = 0;
        for (JsonElement ele : jsonArray) {
            coordinates[i++] = this.jsonArrayToCoordinate(ele.getAsJsonArray());
        }
        return coordinates;
    }

    public AbstractGeometryAdapter(String geometryType, double decimalFactor, GeometryFactory geoFactory) {
        this.geometryType = geometryType;
        this.decimalFactor = decimalFactor;
        this.geoFactory = geoFactory;
    }
}

