/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;

public class GeometryAdapter
implements JsonSerializer<Geometry>,
JsonDeserializer<Geometry> {
    private final Locale locale = Locale.ENGLISH;
    private final Map<String, BiFunction<JsonSerializationContext, Geometry, JsonElement>> serializationMap = new HashMap<String, BiFunction<JsonSerializationContext, Geometry, JsonElement>>();
    private final Map<String, BiFunction<JsonDeserializationContext, JsonElement, Geometry>> deserializationMap;

    public GeometryAdapter() {
        this.addSerializationFunction(Point.class, this.serializationMap);
        this.addSerializationFunction(MultiPoint.class, this.serializationMap);
        this.addSerializationFunction(LineString.class, this.serializationMap);
        this.addSerializationFunction(MultiLineString.class, this.serializationMap);
        this.addSerializationFunction(Polygon.class, this.serializationMap);
        this.addSerializationFunction(MultiPolygon.class, this.serializationMap);
        this.deserializationMap = new HashMap<String, BiFunction<JsonDeserializationContext, JsonElement, Geometry>>();
        this.addDeserializationFunction(Point.class, this.deserializationMap);
        this.addDeserializationFunction(MultiPoint.class, this.deserializationMap);
        this.addDeserializationFunction(LineString.class, this.deserializationMap);
        this.addDeserializationFunction(MultiLineString.class, this.deserializationMap);
        this.addDeserializationFunction(Polygon.class, this.deserializationMap);
        this.addDeserializationFunction(MultiPolygon.class, this.deserializationMap);
    }

    private void addSerializationFunction(Class<?> geoClass, Map<String, BiFunction<JsonSerializationContext, Geometry, JsonElement>> map) {
        map.put(geoClass.getSimpleName().toLowerCase(this.locale), (context, geo) -> context.serialize(geo, (Type)geoClass));
    }

    private void addDeserializationFunction(Class<?> geoClass, Map<String, BiFunction<JsonDeserializationContext, JsonElement, Geometry>> map) {
        map.put(geoClass.getSimpleName().toLowerCase(this.locale), (context, geo) -> (Geometry)context.deserialize(geo, (Type)geoClass));
    }

    public JsonElement serialize(Geometry src, Type typeOfSrc, JsonSerializationContext context) {
        BiFunction<JsonSerializationContext, Geometry, JsonElement> serializationFunction = this.serializationMap.get(src.getGeometryType().toLowerCase(this.locale));
        if (serializationFunction == null) {
            throw new JsonParseException(String.format("Unknown Geometry type '%s'.", src.getGeometryType()));
        }
        return serializationFunction.apply(context, src);
    }

    public Geometry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String geometryType = json.getAsJsonObject().get("type").getAsString().toLowerCase(this.locale);
        BiFunction<JsonDeserializationContext, JsonElement, Geometry> deserializationFunction = this.deserializationMap.get(geometryType);
        if (deserializationFunction == null) {
            throw new JsonParseException(String.format("Unknown Geometry type '%s'.", geometryType));
        }
        return deserializationFunction.apply(context, json);
    }
}

