/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import de.gerdiproject.json.geo.adapters.AbstractGeometryAdapter;

public class MultiLineStringAdapter
extends AbstractGeometryAdapter<MultiLineString> {
    public MultiLineStringAdapter(GeometryFactory geoFactory) {
        super(geoFactory);
    }

    @Override
    protected JsonArray serializeCoordinates(MultiLineString src) {
        JsonArray jsonCoordinates = new JsonArray();
        int size = src.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry lineString = src.getGeometryN(i);
            JsonArray lineStringCoordinates = this.coordinatesToJsonArray(lineString.getCoordinates());
            jsonCoordinates.add((JsonElement)lineStringCoordinates);
        }
        return jsonCoordinates.size() == 0 ? null : jsonCoordinates;
    }

    @Override
    protected MultiLineString deserializeGeometry(JsonArray jsonCoordinates, GeometryFactory factory) {
        int size = jsonCoordinates.size();
        LineString[] lineStrings = new LineString[size];
        int i = 0;
        for (JsonElement lineStringEle : jsonCoordinates) {
            Coordinate[] lineStringCoordinates = this.jsonArrayToCoordinates(lineStringEle.getAsJsonArray());
            lineStrings[i++] = factory.createLineString(lineStringCoordinates);
        }
        return factory.createMultiLineString(lineStrings);
    }
}

