/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.gerdiproject.json.geo.adapters.AbstractGeometryAdapter;
import de.gerdiproject.json.geo.adapters.PolygonAdapter;

public class MultiPolygonAdapter
extends AbstractGeometryAdapter<MultiPolygon> {
    private final PolygonAdapter polygonAdapter;

    public MultiPolygonAdapter(GeometryFactory geoFactory) {
        super(geoFactory);
        this.polygonAdapter = new PolygonAdapter(geoFactory);
    }

    @Override
    protected JsonArray serializeCoordinates(MultiPolygon src) {
        int size = src.getNumGeometries();
        if (size == 0) {
            return null;
        }
        JsonArray jsonCoordinates = new JsonArray();
        for (int i = 0; i < size; ++i) {
            Polygon poly = (Polygon)src.getGeometryN(i);
            JsonArray polyCoordinates = this.polygonAdapter.serializeCoordinates(poly);
            jsonCoordinates.add((JsonElement)polyCoordinates);
        }
        return jsonCoordinates;
    }

    @Override
    protected MultiPolygon deserializeGeometry(JsonArray jsonCoordinates, GeometryFactory factory) {
        Polygon[] polygons = new Polygon[jsonCoordinates.size()];
        int i = 0;
        for (JsonElement ele : jsonCoordinates) {
            polygons[i++] = this.polygonAdapter.deserializeGeometry(ele.getAsJsonArray(), factory);
        }
        return factory.createMultiPolygon(polygons);
    }
}

