/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.IfConditionNode;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.LinkedList;
import java.util.List;

public class ConditionalNode
extends Node {
    private List<IfConditionNode> conditions = new LinkedList<IfConditionNode>();

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        for (IfConditionNode conditionNode : this.conditions) {
            try {
                if (!conditionNode.isDefault() && !(this.checkCondition(model, conditionNode.getValue()) ^ conditionNode.isInverse())) continue;
                conditionNode.getBlock().execute(writer, model, template);
                return;
            }
            catch (ExpressionException e) {
                throw new JadeCompilerException((Node)conditionNode, template.getTemplateLoader(), e);
            }
        }
    }

    private boolean checkCondition(JadeModel model, String condition) throws ExpressionException {
        Boolean value = ExpressionHandler.evaluateBooleanExpression(condition, model);
        return value == null ? false : value;
    }

    public List<IfConditionNode> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IfConditionNode> conditions) {
        this.conditions = conditions;
    }

    @Override
    public ConditionalNode clone() throws CloneNotSupportedException {
        ConditionalNode clone = (ConditionalNode)super.clone();
        clone.conditions = new LinkedList<IfConditionNode>();
        for (IfConditionNode condition : this.conditions) {
            clone.conditions.add((IfConditionNode)condition.clone());
        }
        return clone;
    }
}

