/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.compiler.Utils;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.AttributedNode;
import de.neuland.jade4j.parser.node.ExpressionString;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class TagNode
extends AttributedNode {
    private boolean textOnly;
    private Node textNode;
    private Node codeNode;
    private static final String[] selfClosingTags = new String[]{"meta", "img", "link", "input", "area", "base", "col", "br", "hr", "source"};
    private boolean selfClosing = false;

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

    public void setTextNode(Node textNode) {
        this.textNode = textNode;
    }

    public void setCodeNode(Node codeNode) {
        this.codeNode = codeNode;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public Node getTextNode() {
        return this.textNode;
    }

    public boolean hasTextNode() {
        return this.textNode != null;
    }

    public boolean hasCodeNode() {
        return this.codeNode != null;
    }

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        writer.newline();
        writer.append("<");
        writer.append(this.name);
        writer.append(this.attributes(model, template));
        if (this.isTerse(template)) {
            writer.append(">");
            return;
        }
        if (this.isSelfClosing(template) || this.selfClosing && this.isEmpty()) {
            writer.append("/>");
            return;
        }
        writer.append(">");
        if (this.hasTextNode()) {
            this.textNode.execute(writer, model, template);
        }
        if (this.hasBlock()) {
            writer.increment();
            this.block.execute(writer, model, template);
            writer.decrement();
            writer.newline();
        }
        if (this.hasCodeNode()) {
            this.codeNode.execute(writer, model, template);
        }
        writer.append("</");
        writer.append(this.name);
        writer.append(">");
    }

    private boolean isEmpty() {
        return !this.hasBlock() && !this.hasTextNode() && !this.hasCodeNode();
    }

    public boolean isTerse(JadeTemplate template) {
        return this.isSelfClosing(template) && template.isTerse();
    }

    public boolean isSelfClosing(JadeTemplate template) {
        return !template.isXml() && ArrayUtils.contains((Object[])selfClosingTags, (Object)this.name);
    }

    private String attributes(JadeModel model, JadeTemplate template) {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> mergedAttributes = this.mergeInheritedAttributes(model);
        for (Map.Entry<String, Object> entry : mergedAttributes.entrySet()) {
            try {
                sb.append(this.getAttributeString(entry.getKey(), entry.getValue(), model, template));
            }
            catch (ExpressionException e) {
                throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
            }
        }
        return sb.toString();
    }

    private String getAttributeString(String name, Object attribute, JadeModel model, JadeTemplate template) throws ExpressionException {
        String value = null;
        if (attribute instanceof String) {
            value = this.getInterpolatedAttributeValue(name, attribute, model, template);
        } else if (attribute instanceof Boolean) {
            if (!((Boolean)attribute).booleanValue()) {
                return "";
            }
            value = name;
            if (template.isTerse()) {
                value = null;
            }
        } else if (attribute instanceof ExpressionString) {
            Object expressionValue = this.evaluateExpression((ExpressionString)attribute, model);
            if (expressionValue == null) {
                return "";
            }
            if (expressionValue instanceof Boolean) {
                if (!((Boolean)expressionValue).booleanValue()) {
                    return "";
                }
                value = name;
                if (template.isTerse()) {
                    value = null;
                }
            } else {
                value = expressionValue.toString();
                value = StringEscapeUtils.escapeHtml4((String)value);
            }
        } else {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(" ").append(name);
            if (value != null) {
                sb.append("=").append('\"');
                sb.append(value);
                sb.append('\"');
            }
        }
        return sb.toString();
    }

    private Object evaluateExpression(ExpressionString attribute, JadeModel model) throws ExpressionException {
        String expression = attribute.getValue();
        Object result = ExpressionHandler.evaluateExpression(expression, model);
        if (result instanceof ExpressionString) {
            return this.evaluateExpression((ExpressionString)result, model);
        }
        return result;
    }

    private String getInterpolatedAttributeValue(String name, Object attribute, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        if (!this.preparedAttributeValues.containsKey(name)) {
            this.preparedAttributeValues.put(name, Utils.prepareInterpolate((String)attribute, true));
        }
        List prepared = (List)this.preparedAttributeValues.get(name);
        try {
            return Utils.interpolate(prepared, model);
        }
        catch (ExpressionException e) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
        }
    }

    public void setSelfClosing(boolean selfClosing) {
        this.selfClosing = selfClosing;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }
}

