/*
 * Copyright 2013 Carnegie Mellon University.
 * Portions Copyright 2004 Sun Microsystems, Inc.
 * Portions Copyright 2004 Mitsubishi Electric Research Laboratories.
 * All Rights Reserved.  Use is subject to license terms.
 *
 * See the file "license.terms" for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL
 * WARRANTIES.
 */

package edu.cmu.sphinx.util;


public class TimeFrame {

    public static final TimeFrame NULL = new TimeFrame(0);
    public static final TimeFrame INFINITE = new TimeFrame(Long.MAX_VALUE);

    private final long start;
    private final long end;

    public TimeFrame(long duration) {
        this(0, duration);
    }

    public TimeFrame(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return start;
    }

    public long getEnd() {
        return end;
    }

    public long length() {
        return end - start;
    }

    @Override
    public String toString() {
        return String.format("%d:%d", start, end);
    }
}
