/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.client.MySqlConnectionClosedException;
import dev.miku.r2dbc.mysql.client.MySqlConnectionException;
import dev.miku.r2dbc.mysql.client.MySqlProtocolException;
import io.r2dbc.spi.R2dbcException;

final class ClientExceptions {
    static R2dbcException exchangeClosed() {
        return new MySqlConnectionClosedException("Cannot exchange messages because the connection is closed");
    }

    static R2dbcException unexpectedClosed() {
        return new MySqlConnectionClosedException("Connection unexpectedly closed");
    }

    static R2dbcException expectedClosed() {
        return new MySqlConnectionClosedException("Connection closed");
    }

    static R2dbcException unsupportedProtocol(String type) {
        return new MySqlProtocolException(String.format("Unexpected protocol message: [%s]", type));
    }

    static R2dbcException wrap(Throwable e) {
        if (e instanceof R2dbcException) {
            return (R2dbcException)e;
        }
        return new MySqlConnectionException(e);
    }

    private ClientExceptions() {
    }
}

