/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.BigDecimalCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.LongCodec;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class BigIntegerCodec
extends AbstractClassedCodec<BigInteger> {
    private static final String LONG_MAX_VALUE = Long.toString(Long.MAX_VALUE);

    BigIntegerCodec(ByteBufAllocator allocator) {
        super(allocator, BigInteger.class);
    }

    @Override
    public BigInteger decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        return binary ? BigIntegerCodec.decodeBinary(value, info) : BigIntegerCodec.decodeText(value, info);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigInteger;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new BigIntegerParameter(this.allocator, (BigInteger)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return TypePredicates.isInt(info.getType());
    }

    private static boolean isGreaterThanMaxValue(String num) {
        int length = num.length();
        if (length != LONG_MAX_VALUE.length()) {
            return length > LONG_MAX_VALUE.length();
        }
        return num.compareTo(LONG_MAX_VALUE) > 0;
    }

    static BigInteger unsignedBigInteger(long negative) {
        byte[] bits = new byte[]{0, (byte)(negative >>> 56), (byte)(negative >>> 48), (byte)(negative >>> 40), (byte)(negative >>> 32), (byte)(negative >>> 24), (byte)(negative >>> 16), (byte)(negative >>> 8), (byte)negative};
        return new BigInteger(bits);
    }

    private static BigInteger decodeText(ByteBuf value, FieldInformation info) {
        if (info.getType() == 8 && (info.getDefinitions() & 0x20) != 0) {
            String num;
            if (value.getByte(value.readerIndex()) == 43) {
                value.skipBytes(1);
            }
            if (BigIntegerCodec.isGreaterThanMaxValue(num = value.toString(StandardCharsets.US_ASCII))) {
                return new BigInteger(num);
            }
            return BigInteger.valueOf(BigIntegerCodec.parseUnsigned(num));
        }
        return BigInteger.valueOf(LongCodec.parse(value));
    }

    private static BigInteger decodeBinary(ByteBuf value, FieldInformation info) {
        boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
        switch (info.getType()) {
            case 8: {
                long v = value.readLongLE();
                if (isUnsigned && v < 0L) {
                    return BigIntegerCodec.unsignedBigInteger(v);
                }
                return BigInteger.valueOf(v);
            }
            case 3: {
                if (isUnsigned) {
                    return BigInteger.valueOf(value.readUnsignedIntLE());
                }
                return BigInteger.valueOf(value.readIntLE());
            }
            case 9: {
                return BigInteger.valueOf(value.readIntLE());
            }
            case 2: {
                if (isUnsigned) {
                    return BigInteger.valueOf(value.readUnsignedShortLE());
                }
                return BigInteger.valueOf(value.readShortLE());
            }
            case 13: {
                return BigInteger.valueOf(value.readShortLE());
            }
        }
        if (isUnsigned) {
            return BigInteger.valueOf(value.readUnsignedByte());
        }
        return BigInteger.valueOf(value.readByte());
    }

    private static long parseUnsigned(String num) {
        long value = 0L;
        int size = num.length();
        for (int i = 0; i < size; ++i) {
            value = value * 10L + (long)(num.charAt(i) - 48);
        }
        return value;
    }

    private static class BigIntegerParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final BigInteger value;

        private BigIntegerParameter(ByteBufAllocator allocator, BigInteger value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> BigDecimalCodec.encodeAscii(this.allocator, this.value.toString()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeBigInteger(this.value));
        }

        @Override
        public short getType() {
            return 15;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigIntegerParameter)) {
                return false;
            }
            BigIntegerParameter that = (BigIntegerParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

