/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

abstract class FixedSizeClientMessage
implements ClientMessage {
    FixedSizeClientMessage() {
    }

    protected abstract int size();

    protected abstract void writeTo(ByteBuf var1);

    public Mono<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        return Mono.fromSupplier(() -> {
            int s = this.size();
            ByteBuf buf = allocator.buffer(s, s);
            try {
                this.writeTo(buf);
                return buf;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        });
    }
}

