/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MulticoreWrapper<I, O> {
    private long maxSubmitBlockTime = 0L;
    private final int nThreads;
    private int lastSubmittedItemId = 0;
    private int lastReturnedId = -1;
    private final boolean orderResults;
    private final PriorityBlockingQueue<QueueItem<O>> outputQueue;
    private final ThreadPoolExecutor threadPool;
    private final ExecutorCompletionService<JobResult<O>> queue;
    private final Queue<Integer> idleProcessors;
    private final List<ThreadsafeProcessor<I, O>> processorList;
    private final Map<Integer, Future<JobResult<O>>> runningJobs;

    public MulticoreWrapper(int nThreads, ThreadsafeProcessor<I, O> processor) {
        this(nThreads, processor, true);
    }

    public MulticoreWrapper(int numThreads, ThreadsafeProcessor<I, O> processor, boolean orderResults) {
        this.nThreads = numThreads <= 0 ? Runtime.getRuntime().availableProcessors() : numThreads;
        this.orderResults = orderResults;
        this.outputQueue = new PriorityBlockingQueue(10 * this.nThreads);
        this.threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.nThreads);
        this.queue = new ExecutorCompletionService(this.threadPool);
        this.processorList = new ArrayList<ThreadsafeProcessor<I, O>>(this.nThreads);
        this.idleProcessors = new ConcurrentLinkedQueue<Integer>();
        this.runningJobs = new HashMap<Integer, Future<JobResult<O>>>();
        this.threadPool.allowCoreThreadTimeOut(false);
        this.processorList.add(processor);
        this.idleProcessors.add(0);
        for (int i = 1; i < this.nThreads; ++i) {
            this.processorList.add(processor.newInstance());
            this.idleProcessors.add(i);
        }
    }

    public void setMaxBlockTime(long t) {
        this.maxSubmitBlockTime = t;
    }

    public String toString() {
        return String.format("active: %d/%d  submitted: %d  completed: %d  input_q: %d  output_q: %d  idle_q: %d", this.threadPool.getActiveCount(), this.threadPool.getPoolSize(), this.threadPool.getTaskCount(), this.threadPool.getCompletedTaskCount(), this.threadPool.getQueue().size(), this.outputQueue.size(), this.idleProcessors.size());
    }

    public synchronized void put(I item) throws RejectedExecutionException {
        if (this.idleProcessors.peek() == null) {
            this.blockingGetResult();
        }
        int procId = this.idleProcessors.poll();
        int itemId = this.lastSubmittedItemId++;
        CallableJob<I, O> job = new CallableJob<I, O>(item, itemId, this.processorList.get(procId), procId);
        Future<JobResult<O>> future = this.queue.submit(job);
        this.runningJobs.put(itemId, future);
    }

    private void blockingGetResult() {
        try {
            Future<JobResult<O>> resultFuture = this.maxSubmitBlockTime > 0L ? this.queue.poll(this.maxSubmitBlockTime, TimeUnit.MILLISECONDS) : this.queue.take();
            if (resultFuture != null) {
                JobResult<O> result = resultFuture.get();
                QueueItem output = new QueueItem(result.output, result.inputItemId);
                this.outputQueue.add(output);
                this.idleProcessors.add(result.processorId);
                this.runningJobs.remove(result.inputItemId);
                return;
            }
        }
        catch (InterruptedException e) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(e);
        }
        for (Map.Entry<Integer, Future<JobResult<O>>> entry : this.runningJobs.entrySet()) {
            entry.getValue().cancel(true);
            QueueItem<Object> output = new QueueItem<Object>(null, entry.getKey());
            this.outputQueue.add(output);
        }
        this.runningJobs.clear();
        for (int i = 0; i < this.nThreads; ++i) {
            try {
                Future<JobResult<O>> result = this.queue.take();
                this.idleProcessors.add(i);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void join() {
        if (!this.threadPool.isShutdown()) {
            while (this.idleProcessors.size() != this.nThreads) {
                this.blockingGetResult();
            }
            this.threadPool.shutdown();
        }
    }

    public boolean peek() {
        if (this.outputQueue.isEmpty()) {
            return false;
        }
        int nextId = this.outputQueue.peek().id;
        return this.orderResults ? nextId == this.lastReturnedId + 1 : true;
    }

    public O poll() {
        if (!this.peek()) {
            return null;
        }
        ++this.lastReturnedId;
        QueueItem<O> result = this.outputQueue.poll();
        return result.item;
    }

    private static class QueueItem<O>
    implements Comparable<QueueItem<O>> {
        public final int id;
        public final O item;

        public QueueItem(O item, int id) {
            this.item = item;
            this.id = id;
        }

        @Override
        public int compareTo(QueueItem<O> other) {
            return this.id - other.id;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof QueueItem)) {
                return false;
            }
            QueueItem otherQueue = (QueueItem)other;
            return this.id == otherQueue.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static class CallableJob<I, O>
    implements Callable<JobResult<O>> {
        private final I item;
        private final int itemId;
        private final ThreadsafeProcessor<I, O> processor;
        private final int processorId;

        public CallableJob(I item, int itemId, ThreadsafeProcessor<I, O> processor, int processorId) {
            this.item = item;
            this.itemId = itemId;
            this.processor = processor;
            this.processorId = processorId;
        }

        @Override
        public JobResult<O> call() throws Exception {
            return new JobResult<O>(this.processor.process(this.item), this.itemId, this.processorId);
        }
    }

    private static class JobResult<O> {
        public final O output;
        public final int inputItemId;
        public final int processorId;

        public JobResult(O result, int inputItemId, int processorId) {
            this.output = result;
            this.inputItemId = inputItemId;
            this.processorId = processorId;
        }
    }
}

