/*
 * Decompiled with CFR 0.152.
 */
package o2o.openplatform.sdk.util;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static final String HTTP_CONTENT_CHARSET = "UTF-8";
    public static final Integer MAX_TIME_OUT = 10000;
    public static final Integer MAX_IDLE_TIME_OUT = 20000;
    public static final Long MAX_MANAGER_TIME = 1000L;
    public static final Integer MAX_CONN = 128;
    public static final Integer MAX_HOST_CONN = 32;
    public static final HttpClient httpClient = new HttpClient();

    public static String sendSimplePostRequest(String url, Map<String, Object> param) throws Exception {
        String result = null;
        PostMethod post = new PostMethod(url);
        try {
            post.getParams().setParameter("http.protocol.content-charset", (Object)HTTP_CONTENT_CHARSET);
            if (param != null) {
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    if (entry.getValue() == null) continue;
                    post.addParameter(entry.getKey(), (String)entry.getValue());
                }
            }
            post.addRequestHeader(new Header("Connection", "close"));
            httpClient.executeMethod((HttpMethod)post);
            if (post.getStatusCode() == 200) {
                String i$ = post.getResponseBodyAsString();
                return i$;
            }
            result = "{\"code\":\"" + post.getStatusCode() + "\", \"msg\":\"" + post.getStatusText() + "\"}";
            post.abort();
        }
        catch (ConnectTimeoutException e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u8fde\u63a5\u8d85\u65f6\"}";
            LOGGER.error("\u8c03\u7528HttpsUtil.sendSimplePostRequest ConnectTimeoutException, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (SocketTimeoutException e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u54cd\u5e94\u8d85\u65f6\"}";
            LOGGER.error("\u8c03\u7528HttpUtil.sendSimplePostRequest SocketTimeoutException, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u54cd\u5e94\u8d85\u65f6\"}";
            LOGGER.error("\u8c03\u7528HttpUtil.sendSimplePostRequest IOException, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u670d\u52a1\u5f00\u5c0f\u5dee\uff0c\u7cfb\u7edf\u52aa\u529b\u4fee\u590d\u4e2d\"}";
            LOGGER.error("\u8c03\u7528HttpUtil.sendSimplePostRequest Exception, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            post.releaseConnection();
        }
        return result;
    }

    public static String sendSimpleGetRequest(String url, Map<String, Object> param) throws Exception {
        String result = null;
        StringBuilder sb = new StringBuilder();
        GetMethod get = null;
        try {
            String paramStr = "";
            if (param != null) {
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    if (entry.getValue() == null) continue;
                    sb.append(entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), "utf-8")).append("&");
                }
                paramStr = sb.toString();
                paramStr = paramStr.substring(0, paramStr.length() - 1);
            }
            get = new GetMethod(url + "?" + paramStr);
            get.getParams().setParameter("http.protocol.content-charset", (Object)HTTP_CONTENT_CHARSET);
            get.addRequestHeader(new Header("Connection", "close"));
            httpClient.executeMethod((HttpMethod)get);
            if (get.getStatusCode() == 200) {
                String string = get.getResponseBodyAsString();
                return string;
            }
            get.abort();
        }
        catch (IOException ex) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u54cd\u5e94\u8d85\u65f6\"}";
            LOGGER.error("HttpUtil.sendSimpleGetRequest\u54cd\u5e94\u8d85\u65f6, url=" + url, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            result = "{\"code\":\"-1\", \"msg\":\"\u670d\u52a1\u5f00\u5c0f\u5dee\uff0c\u7cfb\u7edf\u52aa\u529b\u4fee\u590d\u4e2d\"}";
            LOGGER.error("\u8c03\u7528HttpUtil.sendSimpleGetRequest Exception, url=" + url, (Throwable)ex);
            throw ex;
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return result;
    }

    static {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue());
        connectionManager.getParams().setParameter("http.connection-manager.max-total", (Object)MAX_CONN);
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(MAX_HOST_CONN.intValue());
        httpClient.setHttpConnectionManager((HttpConnectionManager)connectionManager);
        httpClient.getParams().setIntParameter("http.socket.timeout", MAX_TIME_OUT.intValue());
        httpClient.getParams().setIntParameter("http.connection.timeout", MAX_TIME_OUT.intValue());
        httpClient.getParams().setLongParameter("http.conn-manager.timeout", MAX_MANAGER_TIME.longValue());
    }
}

