/*
 * Decompiled with CFR 0.152.
 */
package o2o.openplatform.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsUtil.class);
    private static final String HTTP_CONTENT_CHARSET = "UTF-8";
    public static final Integer CONN_TIME_OUT = 3000;
    public static final Integer READ_TIME_OUT = 3000;
    public static HttpClient client = null;

    public static String sendPost(String url, Map<String, Object> param) throws Exception {
        HttpPost post = new HttpPost(url);
        String result = "";
        try {
            if (param != null && !param.isEmpty()) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                Set<Map.Entry<String, Object>> entrySet = param.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    formParams.add(new BasicNameValuePair(entry.getKey(), ((String[])entry.getValue())[0]));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
                post.setEntity((HttpEntity)entity);
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (CONN_TIME_OUT != null) {
                customReqConf.setConnectTimeout(CONN_TIME_OUT.intValue());
            }
            if (READ_TIME_OUT != null) {
                customReqConf.setSocketTimeout(READ_TIME_OUT.intValue());
            }
            post.setConfig(customReqConf.build());
            HttpResponse res = client.execute((HttpUriRequest)post);
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)HTTP_CONTENT_CHARSET);
        }
        catch (ConnectTimeoutException e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u8fde\u63a5\u8d85\u65f6\"}";
            LOGGER.error("\u8c03\u7528HttpsUtil.sendPost ConnectTimeoutException, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (SocketTimeoutException e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u54cd\u5e94\u8d85\u65f6\"}";
            LOGGER.error("\u8c03\u7528HttpsUtil.sendPost SocketTimeoutException, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u54cd\u5e94\u8d85\u65f6\"}";
            LOGGER.error("\u8c03\u7528HttpsUtil.sendPost IOException, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u670d\u52a1\u5f00\u5c0f\u5dee\uff0c\u7cfb\u7edf\u52aa\u529b\u4fee\u590d\u4e2d\"}";
            LOGGER.error("\u8c03\u7528HttpsUtil.sendPost Exception, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                try {
                    ((CloseableHttpClient)client).close();
                }
                catch (IOException e) {
                    LOGGER.error("\u8c03\u7528HttpsUtil.sendPost\u5173\u95ed\u8fde\u63a5 IOException, url=" + url, (Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postForm(String url, Map<String, String> params, Map<String, String> headers, Integer connTimeout, Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        HttpPost post = new HttpPost(url);
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                Set<Map.Entry<String, String>> entrySet = params.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
                post.setEntity((HttpEntity)entity);
            }
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            HttpResponse res = client.execute((HttpUriRequest)post);
            String string = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)HTTP_CONTENT_CHARSET);
            return string;
        }
        finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }
    }

    public static String sendGet(String url, Map<String, Object> param) throws Exception {
        HttpGet get = null;
        String result = "";
        String paramStr = "";
        try {
            if (param != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    if (entry.getValue() == null) continue;
                    sb.append(entry.getKey()).append("=").append(URLEncoder.encode(((String[])entry.getValue())[0], HTTP_CONTENT_CHARSET)).append("&");
                }
                paramStr = sb.toString();
                paramStr = paramStr.substring(0, paramStr.length() - 1);
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (CONN_TIME_OUT != null) {
                customReqConf.setConnectTimeout(CONN_TIME_OUT.intValue());
            }
            if (READ_TIME_OUT != null) {
                customReqConf.setSocketTimeout(READ_TIME_OUT.intValue());
            }
            get = new HttpGet(url + "?" + paramStr);
            get.setConfig(customReqConf.build());
            HttpResponse res = client.execute((HttpUriRequest)get);
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)HTTP_CONTENT_CHARSET);
        }
        catch (IOException e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u8bf7\u6c42\u54cd\u5e94\u8d85\u65f6\"}";
            LOGGER.error("\u8c03\u7528HttpsUtil.sendGet IOException, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            result = "{\"code\":\"-1\", \"msg\":\"\u670d\u52a1\u5f00\u5c0f\u5dee\uff0c\u7cfb\u7edf\u52aa\u529b\u4fee\u590d\u4e2d\"}";
            LOGGER.error("\u8c03\u7528HttpsUtil.sendGet Exception, url=" + url, (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                try {
                    ((CloseableHttpClient)client).close();
                }
                catch (IOException e) {
                    LOGGER.error("\u8c03\u7528HttpsUtil.sendGet \u5173\u95ed\u8fde\u63a5IOException, url=" + url, (Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static boolean checkUrlIsHttps(String url) {
        boolean result = false;
        URI uri = null;
        try {
            URL ur = new URL(url);
            uri = ur.toURI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (uri != null) {
            if ("https".equalsIgnoreCase(uri.getScheme())) {
                result = true;
            }
        } else if (url.toLowerCase().indexOf("https") == 0) {
            result = true;
        }
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            cm.setMaxTotal(100);
            cm.setDefaultMaxPerRoute(20);
            client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).setConnectionManagerShared(true).build();
        }
        catch (Exception e) {
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(100);
            cm.setDefaultMaxPerRoute(20);
            client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
            e.printStackTrace();
        }
    }
}

