/*
 * Decompiled with CFR 0.152.
 */
package o2o.openplatform.sdk.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getMD5String(String s) {
        try {
            return MD5Util.getMD5String(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("MD5\u52a0\u5bc6\u5931\u8d25\uff0c\u83b7\u53d6\u5b57\u7b26\u4e32UTF-8\u5b57\u8282\u6570\u7ec4\u5f02\u5e38\uff1a" + ex.getLocalizedMessage());
        }
    }

    public static String getMD5String(byte[] bytes) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            messagedigest.update(bytes);
            return MD5Util.bufferToHex(messagedigest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(MD5Util.class.getName() + "\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util\u3002" + ex.getLocalizedMessage());
        }
    }

    private static String bufferToHex(byte[] bytes) {
        return MD5Util.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            MD5Util.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }
}

