/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class SimplePropertyFilter
implements PropertyFilter,
ValueFilter {
    protected Logger logger = null;
    private List<String> ignoreList = new ArrayList<String>();
    private List<String> filterList = new ArrayList<String>();

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.getClass().getName());
        }
        return this.logger;
    }

    public SimplePropertyFilter(String ... fields) {
        this.addFilterFields(fields);
    }

    public void clearFilterFields() {
        this.filterList.clear();
    }

    public void clearIgnoreFields() {
        this.ignoreList.clear();
    }

    public void addFilterFields(String ... fields) {
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                String fieldname = fields[i];
                if (StringUtils.isEmpty((Object)fieldname)) continue;
                this.filterList.add(fieldname.toLowerCase());
            }
        }
    }

    public void addIgnoreFields(String ... fields) {
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                String fieldname = fields[i];
                if (StringUtils.isEmpty((Object)fieldname)) continue;
                this.ignoreList.add(fieldname.toLowerCase());
            }
        }
    }

    public boolean apply(Object object, String name, Object value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)String.format("Bean:[%1$s] apply:{Object:%2$s,Name%3$s,Value:%4$s}", this.getClass().getCanonicalName(), object.toString(), StringUtils.isEmpty((Object)name) ? "" : name, value == null ? "" : value.toString()));
        }
        if (!StringUtils.isEmpty((Object)name)) {
            String fieldname = name.toLowerCase();
            if (this.ignoreList.contains(fieldname)) {
                return false;
            }
            if (this.filterList.size() > 0 && !this.filterList.contains(fieldname)) {
                return false;
            }
        }
        return true;
    }

    public Object process(Object object, String name, Object value) {
        return value;
    }
}

