/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

public class BasicHeaderValueParser
implements HeaderValueParser {
    public static final BasicHeaderValueParser DEFAULT = new BasicHeaderValueParser();

    public static final HeaderElement[] parseElements(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        return parser.parseElements(buffer, 0, buffer.length());
    }

    public HeaderElement[] parseElements(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<HeaderElement> elements = new ArrayList<HeaderElement>();
        int from = indexFrom;
        boolean qouted = false;
        boolean escaped = false;
        for (int cur = indexFrom; cur < indexTo; ++cur) {
            char ch = buffer.charAt(cur);
            if (ch == '\"' && !escaped) {
                qouted = !qouted;
            }
            HeaderElement element = null;
            if (!qouted && ch == ',') {
                element = this.parseHeaderElement(buffer, from, cur);
                from = cur + 1;
            } else if (cur == indexTo - 1) {
                element = this.parseHeaderElement(buffer, from, indexTo);
            }
            if (element != null && (element.getName().length() != 0 || element.getValue() != null)) {
                elements.add(element);
            }
            escaped = escaped ? false : qouted && ch == '\\';
        }
        return elements.toArray(new HeaderElement[elements.size()]);
    }

    public static final HeaderElement parseHeaderElement(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        return parser.parseHeaderElement(buffer, 0, buffer.length());
    }

    public HeaderElement parseHeaderElement(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        NameValuePair[] nvps = this.parseParameters(buffer, indexFrom, indexTo);
        return this.createHeaderElement(nvps);
    }

    protected HeaderElement createHeaderElement(NameValuePair[] nvps) {
        return new BasicHeaderElement(nvps);
    }

    public static final NameValuePair[] parseParameters(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        return parser.parseParameters(buffer, 0, buffer.length());
    }

    public NameValuePair[] parseParameters(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        int from = indexFrom;
        boolean qouted = false;
        boolean escaped = false;
        for (int cur = indexFrom; cur < indexTo; ++cur) {
            char ch = buffer.charAt(cur);
            if (ch == '\"' && !escaped) {
                qouted = !qouted;
            }
            NameValuePair param = null;
            if (!qouted && ch == ';') {
                param = this.parseNameValuePair(buffer, from, cur);
                from = cur + 1;
            } else if (cur == indexTo - 1) {
                param = this.parseNameValuePair(buffer, from, indexTo);
            }
            if (param != null && (param.getName().length() != 0 || param.getValue() != null)) {
                params.add(param);
            }
            escaped = escaped ? false : qouted && ch == '\\';
        }
        return params.toArray(new NameValuePair[params.size()]);
    }

    public static final NameValuePair parseNameValuePair(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        return parser.parseNameValuePair(buffer, 0, buffer.length());
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        int i1;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        int eq = buffer.indexOf(61, indexFrom, indexTo);
        if (eq < 0) {
            return this.createNameValuePair(buffer.substringTrimmed(indexFrom, indexTo), null);
        }
        String name = buffer.substringTrimmed(indexFrom, eq);
        int i2 = indexTo;
        for (i1 = eq + 1; i1 < i2 && HTTP.isWhitespace(buffer.charAt(i1)); ++i1) {
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer.charAt(i2 - 1))) {
            --i2;
        }
        if (i2 - i1 >= 2 && buffer.charAt(i1) == '\"' && buffer.charAt(i2 - 1) == '\"') {
            ++i1;
            --i2;
        }
        String value = buffer.substring(i1, i2);
        return this.createNameValuePair(name, value);
    }

    protected NameValuePair createNameValuePair(String name, String value) {
        return new BasicNameValuePair(name, value);
    }
}

