/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import org.slf4j.LoggerFactory;

public class RaftMetrics {
    protected final String partition;
    protected final String partitionGroupName;

    RaftMetrics(String partitionName) {
        String groupName;
        int partitionId;
        try {
            String[] parts = partitionName.split("-");
            partitionId = Integer.parseInt(parts[parts.length - 1]);
            groupName = parts[0];
        }
        catch (Exception e) {
            LoggerFactory.getLogger(RaftMetrics.class).debug("Cannot extract partition group name and id from {}, defaulting to raft and 0", (Object)partitionName);
            partitionId = 0;
            groupName = "raft";
        }
        this.partition = String.valueOf(partitionId);
        this.partitionGroupName = groupName;
    }
}

