/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.CompensateEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.MessageEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.SignalEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ThrowEvent;

public abstract class AbstractThrowEventBuilder<B extends AbstractThrowEventBuilder<B, E>, E extends ThrowEvent>
extends AbstractEventBuilder<B, E> {
    protected AbstractThrowEventBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    public B message(String messageName) {
        MessageEventDefinition messageEventDefinition = this.createMessageEventDefinition(messageName);
        ((ThrowEvent)this.element).getEventDefinitions().add(messageEventDefinition);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public MessageEventDefinitionBuilder messageEventDefinition() {
        return this.messageEventDefinition(null);
    }

    public MessageEventDefinitionBuilder messageEventDefinition(String id) {
        MessageEventDefinition messageEventDefinition = this.createEmptyMessageEventDefinition();
        if (id != null) {
            messageEventDefinition.setId(id);
        }
        ((ThrowEvent)this.element).getEventDefinitions().add(messageEventDefinition);
        return new MessageEventDefinitionBuilder(this.modelInstance, messageEventDefinition);
    }

    public B signal(String signalName) {
        SignalEventDefinition signalEventDefinition = this.createSignalEventDefinition(signalName);
        ((ThrowEvent)this.element).getEventDefinitions().add(signalEventDefinition);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public SignalEventDefinitionBuilder signalEventDefinition(String signalName) {
        SignalEventDefinition signalEventDefinition = this.createSignalEventDefinition(signalName);
        ((ThrowEvent)this.element).getEventDefinitions().add(signalEventDefinition);
        return new SignalEventDefinitionBuilder(this.modelInstance, signalEventDefinition);
    }

    public B escalation(String escalationCode) {
        EscalationEventDefinition escalationEventDefinition = this.createEscalationEventDefinition(escalationCode);
        ((ThrowEvent)this.element).getEventDefinitions().add(escalationEventDefinition);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public CompensateEventDefinitionBuilder compensateEventDefinition() {
        return this.compensateEventDefinition(null);
    }

    public CompensateEventDefinitionBuilder compensateEventDefinition(String id) {
        CompensateEventDefinition eventDefinition = this.createInstance(CompensateEventDefinition.class);
        if (id != null) {
            eventDefinition.setId(id);
        }
        ((ThrowEvent)this.element).getEventDefinitions().add(eventDefinition);
        return new CompensateEventDefinitionBuilder(this.modelInstance, eventDefinition);
    }
}

