/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public final class ZeebeElementValidator<T extends ModelElementInstance>
implements ModelElementValidator<T> {
    private final Class<T> elementType;
    private final List<AttributeAssertion<T>> attributeAssertions = new ArrayList<AttributeAssertion<T>>();

    private ZeebeElementValidator(Class<T> elementType) {
        this.elementType = elementType;
    }

    public Class<T> getElementType() {
        return this.elementType;
    }

    public void validate(T element, ValidationResultCollector validationResultCollector) {
        this.attributeAssertions.forEach(assertions -> {
            String attributeValue = (String)((AttributeAssertion)assertions).attributeSupplier.apply(element);
            if (attributeValue == null || attributeValue.isEmpty()) {
                validationResultCollector.addError(0, String.format("Attribute '%s' must be present and not empty", ((AttributeAssertion)assertions).attributeName));
            }
        });
    }

    public ZeebeElementValidator<T> hasNonEmptyAttribute(Function<T, String> attributeSupplier, String attributeName) {
        this.attributeAssertions.add(new AttributeAssertion(attributeSupplier, attributeName));
        return this;
    }

    public static <T extends ModelElementInstance> ZeebeElementValidator<T> verifyThat(Class<T> elementType) {
        return new ZeebeElementValidator<T>(elementType);
    }

    private static final class AttributeAssertion<T extends ModelElementInstance> {
        private final Function<T, String> attributeSupplier;
        private final String attributeName;

        private AttributeAssertion(Function<T, String> attributeSupplier, String attributeName) {
            this.attributeSupplier = attributeSupplier;
            this.attributeName = attributeName;
        }
    }
}

