/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalSegmentDescriptor;
import io.camunda.zeebe.journal.file.JournalSegmentFile;
import io.camunda.zeebe.journal.file.MappedJournalSegmentReader;
import io.camunda.zeebe.journal.file.MappedJournalSegmentWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.Set;
import org.agrona.IoUtil;

class JournalSegment
implements AutoCloseable {
    private static final ByteOrder ENDIANNESS = ByteOrder.LITTLE_ENDIAN;
    private final JournalSegmentFile file;
    private final JournalSegmentDescriptor descriptor;
    private final JournalIndex index;
    private final MappedJournalSegmentWriter writer;
    private final Set<MappedJournalSegmentReader> readers = Sets.newConcurrentHashSet();
    private boolean open = true;
    private final MappedByteBuffer buffer;

    public JournalSegment(JournalSegmentFile file, JournalSegmentDescriptor descriptor, long maxWrittenIndex, JournalIndex journalIndex) {
        this.file = file;
        this.descriptor = descriptor;
        this.index = journalIndex;
        this.buffer = IoUtil.mapExistingFile((File)file.file(), (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (String)file.name(), (long)0L, (long)descriptor.maxSegmentSize());
        this.buffer.order(ENDIANNESS);
        this.writer = this.createWriter(maxWrittenIndex);
    }

    public long id() {
        return this.descriptor.id();
    }

    public long index() {
        return this.descriptor.index();
    }

    public long lastIndex() {
        return this.writer.getLastIndex();
    }

    public JournalSegmentFile file() {
        return this.file;
    }

    public JournalSegmentDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean isEmpty() {
        return this.length() == 0L;
    }

    public long length() {
        return this.writer.getNextIndex() - this.index();
    }

    public MappedJournalSegmentWriter writer() {
        this.checkOpen();
        return this.writer;
    }

    MappedJournalSegmentReader createReader() {
        this.checkOpen();
        return new MappedJournalSegmentReader(this.buffer.asReadOnlyBuffer().position(0).order(ENDIANNESS), this, this.index);
    }

    private MappedJournalSegmentWriter createWriter(long lastWrittenIndex) {
        return new MappedJournalSegmentWriter(this.buffer, this, this.index, lastWrittenIndex);
    }

    void onReaderClosed(MappedJournalSegmentReader reader) {
        this.readers.remove(reader);
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.open, (Object)"Segment not open");
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.writer.close();
        this.readers.forEach(MappedJournalSegmentReader::close);
        IoUtil.unmap((MappedByteBuffer)this.buffer);
        this.open = false;
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.file.file().toPath());
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("index", this.index()).toString();
    }
}

