/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import java.io.File;

final class JournalSegmentFile {
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "log";
    private final File file;

    JournalSegmentFile(File file) {
        this.file = file;
    }

    public static boolean isSegmentFile(String name, File file) {
        return JournalSegmentFile.isSegmentFile(name, file.getName());
    }

    public static boolean isSegmentFile(String journalName, String fileName) {
        Preconditions.checkNotNull((Object)journalName, (Object)"journalName cannot be null");
        Preconditions.checkNotNull((Object)fileName, (Object)"fileName cannot be null");
        if (JournalSegmentFile.getSegmentIdFromPath(fileName) == -1) {
            return false;
        }
        return fileName.startsWith(journalName);
    }

    static int getSegmentIdFromPath(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        int partSeparator = name.lastIndexOf(45);
        int extensionSeparator = name.lastIndexOf(46);
        if (extensionSeparator == -1 || partSeparator == -1 || extensionSeparator < partSeparator || !name.endsWith(EXTENSION)) {
            return -1;
        }
        try {
            return Integer.parseInt(name.substring(partSeparator + 1, extensionSeparator));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static File createSegmentFile(String name, File directory, long id) {
        return new File(directory, String.format("%s%s%d%s%s", Preconditions.checkNotNull((Object)name, (Object)"name cannot be null"), Character.valueOf('-'), id, Character.valueOf('.'), EXTENSION));
    }

    public File file() {
        return this.file;
    }

    public String name() {
        return this.file.getName();
    }
}

