/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.file.MessageHeaderEncoder;
import io.camunda.zeebe.journal.file.MetaAttribute;
import io.camunda.zeebe.journal.file.SegmentDescriptorDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class SegmentDescriptorEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 7;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SegmentDescriptorEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 3;
    }

    public int sbeSchemaId() {
        return 7;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SegmentDescriptorEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 20);
        return this;
    }

    public SegmentDescriptorEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(20).templateId(3).schemaId(7).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int idId() {
        return 1;
    }

    public static int idSinceVersion() {
        return 0;
    }

    public static int idEncodingOffset() {
        return 0;
    }

    public static int idEncodingLength() {
        return 8;
    }

    public static String idMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long idNullValue() {
        return Long.MIN_VALUE;
    }

    public static long idMinValue() {
        return -9223372036854775807L;
    }

    public static long idMaxValue() {
        return Long.MAX_VALUE;
    }

    public SegmentDescriptorEncoder id(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int indexId() {
        return 2;
    }

    public static int indexSinceVersion() {
        return 0;
    }

    public static int indexEncodingOffset() {
        return 8;
    }

    public static int indexEncodingLength() {
        return 8;
    }

    public static String indexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long indexNullValue() {
        return Long.MIN_VALUE;
    }

    public static long indexMinValue() {
        return -9223372036854775807L;
    }

    public static long indexMaxValue() {
        return Long.MAX_VALUE;
    }

    public SegmentDescriptorEncoder index(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int maxSegmentSizeId() {
        return 3;
    }

    public static int maxSegmentSizeSinceVersion() {
        return 0;
    }

    public static int maxSegmentSizeEncodingOffset() {
        return 16;
    }

    public static int maxSegmentSizeEncodingLength() {
        return 4;
    }

    public static String maxSegmentSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int maxSegmentSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int maxSegmentSizeMinValue() {
        return -2147483647;
    }

    public static int maxSegmentSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SegmentDescriptorEncoder maxSegmentSize(int value) {
        this.buffer.putInt(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SegmentDescriptorDecoder decoder = new SegmentDescriptorDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 20, 1);
        return decoder.appendTo(builder);
    }
}

