/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractDeploymentRecordValue;
import io.camunda.zeebe.protocol.jackson.record.DeploymentResourceBuilder;
import io.camunda.zeebe.protocol.jackson.record.ProcessMetadataValueBuilder;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractDeploymentRecordValue", generator="Immutables")
public final class DeploymentRecordValueBuilder {
    private List<DeploymentResource> resources = new ArrayList<DeploymentResource>();
    private List<ProcessMetadataValue> processesMetadata = new ArrayList<ProcessMetadataValue>();

    public final DeploymentRecordValueBuilder from(AbstractDeploymentRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final DeploymentRecordValueBuilder from(DeploymentRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        AbstractDeploymentRecordValue instance;
        long bits = 0L;
        if (object instanceof AbstractDeploymentRecordValue) {
            instance = (AbstractDeploymentRecordValue)object;
            if ((bits & 1L) == 0L) {
                this.addAllProcessesMetadata(instance.getProcessesMetadata());
                bits |= 1L;
            }
            if ((bits & 2L) == 0L) {
                this.addAllResources(instance.getResources());
                bits |= 2L;
            }
        }
        if (object instanceof DeploymentRecordValue) {
            instance = (DeploymentRecordValue)object;
            if ((bits & 1L) == 0L) {
                this.addAllProcessesMetadata(instance.getProcessesMetadata());
                bits |= 1L;
            }
            if ((bits & 2L) == 0L) {
                this.addAllResources(instance.getResources());
                bits |= 2L;
            }
        }
    }

    public final DeploymentRecordValueBuilder addResources(DeploymentResource element) {
        this.resources.add(element);
        return this;
    }

    public final DeploymentRecordValueBuilder addResources(DeploymentResource ... elements) {
        for (DeploymentResource element : elements) {
            this.resources.add(element);
        }
        return this;
    }

    @JsonProperty(value="resources")
    @JsonDeserialize(contentAs=DeploymentResourceBuilder.ImmutableDeploymentResource.class)
    public final DeploymentRecordValueBuilder resources(Iterable<? extends DeploymentResource> elements) {
        this.resources.clear();
        return this.addAllResources(elements);
    }

    public final DeploymentRecordValueBuilder addAllResources(Iterable<? extends DeploymentResource> elements) {
        for (DeploymentResource deploymentResource : elements) {
            this.resources.add(deploymentResource);
        }
        return this;
    }

    public final DeploymentRecordValueBuilder addProcessesMetadata(ProcessMetadataValue element) {
        this.processesMetadata.add(element);
        return this;
    }

    public final DeploymentRecordValueBuilder addProcessesMetadata(ProcessMetadataValue ... elements) {
        for (ProcessMetadataValue element : elements) {
            this.processesMetadata.add(element);
        }
        return this;
    }

    @JsonProperty(value="processesMetadata")
    @JsonDeserialize(contentAs=ProcessMetadataValueBuilder.ImmutableProcessMetadataValue.class)
    public final DeploymentRecordValueBuilder processesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
        this.processesMetadata.clear();
        return this.addAllProcessesMetadata(elements);
    }

    public final DeploymentRecordValueBuilder addAllProcessesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
        for (ProcessMetadataValue processMetadataValue : elements) {
            this.processesMetadata.add(processMetadataValue);
        }
        return this;
    }

    public DeploymentRecordValueBuilder clear() {
        this.resources.clear();
        this.processesMetadata.clear();
        return this;
    }

    public AbstractDeploymentRecordValue build() {
        return new ImmutableDeploymentRecordValue(this);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractDeploymentRecordValue", generator="Immutables")
    static final class ImmutableDeploymentRecordValue
    extends AbstractDeploymentRecordValue {
        private final List<DeploymentResource> resources;
        private final List<ProcessMetadataValue> processesMetadata;
        private transient int hashCode;

        private ImmutableDeploymentRecordValue(DeploymentRecordValueBuilder builder) {
            this.resources = DeploymentRecordValueBuilder.createUnmodifiableList(true, builder.resources);
            this.processesMetadata = DeploymentRecordValueBuilder.createUnmodifiableList(true, builder.processesMetadata);
        }

        @Override
        @JsonProperty(value="resources")
        @JsonDeserialize(contentAs=DeploymentResourceBuilder.ImmutableDeploymentResource.class)
        public List<DeploymentResource> getResources() {
            return this.resources;
        }

        @Override
        @JsonProperty(value="processesMetadata")
        @JsonDeserialize(contentAs=ProcessMetadataValueBuilder.ImmutableProcessMetadataValue.class)
        public List<ProcessMetadataValue> getProcessesMetadata() {
            return this.processesMetadata;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableDeploymentRecordValue && this.equalTo(0, (ImmutableDeploymentRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableDeploymentRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.resources.equals(another.resources) && this.processesMetadata.equals(another.processesMetadata);
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + this.resources.hashCode();
            h += (h << 5) + this.processesMetadata.hashCode();
            return h;
        }

        public String toString() {
            return "DeploymentRecordValue{resources=" + this.resources + ", processesMetadata=" + this.processesMetadata + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableDeploymentRecordValue fromJson(Json json) {
            DeploymentRecordValueBuilder builder = new DeploymentRecordValueBuilder();
            if (json.resources != null) {
                builder.addAllResources(json.resources);
            }
            if (json.processesMetadata != null) {
                builder.addAllProcessesMetadata(json.processesMetadata);
            }
            return (ImmutableDeploymentRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractDeploymentRecordValue", generator="Immutables")
        static final class Json
        extends AbstractDeploymentRecordValue {
            List<DeploymentResource> resources = Collections.emptyList();
            List<ProcessMetadataValue> processesMetadata = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="resources")
            @JsonDeserialize(contentAs=DeploymentResourceBuilder.ImmutableDeploymentResource.class)
            public void setResources(List<DeploymentResource> resources) {
                this.resources = resources;
            }

            @JsonProperty(value="processesMetadata")
            @JsonDeserialize(contentAs=ProcessMetadataValueBuilder.ImmutableProcessMetadataValue.class)
            public void setProcessesMetadata(List<ProcessMetadataValue> processesMetadata) {
                this.processesMetadata = processesMetadata;
            }

            @Override
            public List<DeploymentResource> getResources() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<ProcessMetadataValue> getProcessesMetadata() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

