/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractDeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractDeploymentResource", generator="Immutables")
public final class DeploymentResourceBuilder {
    private byte[] resource;
    private String resourceName;

    public final DeploymentResourceBuilder from(DeploymentResource instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final DeploymentResourceBuilder from(AbstractDeploymentResource instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        if (object instanceof DeploymentResource) {
            String resourceNameValue;
            DeploymentResource instance = (DeploymentResource)object;
            byte[] resourceValue = instance.getResource();
            if (resourceValue != null) {
                this.resource(resourceValue);
            }
            if ((resourceNameValue = instance.getResourceName()) != null) {
                this.resourceName(resourceNameValue);
            }
        }
    }

    @JsonProperty(value="resource")
    public final DeploymentResourceBuilder resource(byte ... resource) {
        this.resource = resource;
        return this;
    }

    @JsonProperty(value="resourceName")
    public final DeploymentResourceBuilder resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public DeploymentResourceBuilder clear() {
        this.resource = null;
        this.resourceName = null;
        return this;
    }

    public AbstractDeploymentResource build() {
        return new ImmutableDeploymentResource(this);
    }

    @Generated(from="AbstractDeploymentResource", generator="Immutables")
    static final class ImmutableDeploymentResource
    extends AbstractDeploymentResource {
        private final byte[] resource;
        private final String resourceName;
        private transient int hashCode;

        private ImmutableDeploymentResource(DeploymentResourceBuilder builder) {
            this.resource = builder.resource;
            this.resourceName = builder.resourceName;
        }

        @JsonProperty(value="resource")
        public byte[] getResource() {
            return this.resource;
        }

        @JsonProperty(value="resourceName")
        public String getResourceName() {
            return this.resourceName;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableDeploymentResource && this.equalTo(0, (ImmutableDeploymentResource)another);
        }

        private boolean equalTo(int synthetic, ImmutableDeploymentResource another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return Arrays.equals(this.resource, another.resource) && Objects.equals(this.resourceName, another.resourceName);
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + Arrays.hashCode(this.resource);
            h += (h << 5) + Objects.hashCode(this.resourceName);
            return h;
        }

        public String toString() {
            return "DeploymentResource{resource=" + Arrays.toString(this.resource) + ", resourceName=" + this.resourceName + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableDeploymentResource fromJson(Json json) {
            DeploymentResourceBuilder builder = new DeploymentResourceBuilder();
            if (json.resource != null) {
                builder.resource(json.resource);
            }
            if (json.resourceName != null) {
                builder.resourceName(json.resourceName);
            }
            return (ImmutableDeploymentResource)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractDeploymentResource", generator="Immutables")
        static final class Json
        extends AbstractDeploymentResource {
            byte[] resource;
            String resourceName;

            Json() {
            }

            @JsonProperty(value="resource")
            public void setResource(byte[] resource) {
                this.resource = resource;
            }

            @JsonProperty(value="resourceName")
            public void setResourceName(String resourceName) {
                this.resourceName = resourceName;
            }

            public byte[] getResource() {
                throw new UnsupportedOperationException();
            }

            public String getResourceName() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

