/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractErrorRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractErrorRecordValue", generator="Immutables")
public final class ErrorRecordValueBuilder {
    private String exceptionMessage;
    private String stacktrace;
    private long errorEventPosition;
    private long processInstanceKey;

    public final ErrorRecordValueBuilder from(ErrorRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ErrorRecordValueBuilder from(AbstractErrorRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        if (object instanceof ErrorRecordValue) {
            String exceptionMessageValue;
            ErrorRecordValue instance = (ErrorRecordValue)object;
            this.errorEventPosition(instance.getErrorEventPosition());
            this.processInstanceKey(instance.getProcessInstanceKey());
            String stacktraceValue = instance.getStacktrace();
            if (stacktraceValue != null) {
                this.stacktrace(stacktraceValue);
            }
            if ((exceptionMessageValue = instance.getExceptionMessage()) != null) {
                this.exceptionMessage(exceptionMessageValue);
            }
        }
    }

    @JsonProperty(value="exceptionMessage")
    public final ErrorRecordValueBuilder exceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @JsonProperty(value="stacktrace")
    public final ErrorRecordValueBuilder stacktrace(String stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    @JsonProperty(value="errorEventPosition")
    public final ErrorRecordValueBuilder errorEventPosition(long errorEventPosition) {
        this.errorEventPosition = errorEventPosition;
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final ErrorRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public ErrorRecordValueBuilder clear() {
        this.exceptionMessage = null;
        this.stacktrace = null;
        this.errorEventPosition = 0L;
        this.processInstanceKey = 0L;
        return this;
    }

    public AbstractErrorRecordValue build() {
        return new ImmutableErrorRecordValue(this);
    }

    @Generated(from="AbstractErrorRecordValue", generator="Immutables")
    static final class ImmutableErrorRecordValue
    extends AbstractErrorRecordValue {
        private final String exceptionMessage;
        private final String stacktrace;
        private final long errorEventPosition;
        private final long processInstanceKey;
        private transient int hashCode;

        private ImmutableErrorRecordValue(ErrorRecordValueBuilder builder) {
            this.exceptionMessage = builder.exceptionMessage;
            this.stacktrace = builder.stacktrace;
            this.errorEventPosition = builder.errorEventPosition;
            this.processInstanceKey = builder.processInstanceKey;
        }

        @JsonProperty(value="exceptionMessage")
        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        @JsonProperty(value="stacktrace")
        public String getStacktrace() {
            return this.stacktrace;
        }

        @JsonProperty(value="errorEventPosition")
        public long getErrorEventPosition() {
            return this.errorEventPosition;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableErrorRecordValue && this.equalTo(0, (ImmutableErrorRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableErrorRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return Objects.equals(this.exceptionMessage, another.exceptionMessage) && Objects.equals(this.stacktrace, another.stacktrace) && this.errorEventPosition == another.errorEventPosition && this.processInstanceKey == another.processInstanceKey;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.exceptionMessage);
            h += (h << 5) + Objects.hashCode(this.stacktrace);
            h += (h << 5) + Long.hashCode(this.errorEventPosition);
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            return h;
        }

        public String toString() {
            return "ErrorRecordValue{exceptionMessage=" + this.exceptionMessage + ", stacktrace=" + this.stacktrace + ", errorEventPosition=" + this.errorEventPosition + ", processInstanceKey=" + this.processInstanceKey + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableErrorRecordValue fromJson(Json json) {
            ErrorRecordValueBuilder builder = new ErrorRecordValueBuilder();
            if (json.exceptionMessage != null) {
                builder.exceptionMessage(json.exceptionMessage);
            }
            if (json.stacktrace != null) {
                builder.stacktrace(json.stacktrace);
            }
            if (json.errorEventPositionIsSet) {
                builder.errorEventPosition(json.errorEventPosition);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            return (ImmutableErrorRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractErrorRecordValue", generator="Immutables")
        static final class Json
        extends AbstractErrorRecordValue {
            String exceptionMessage;
            String stacktrace;
            long errorEventPosition;
            boolean errorEventPositionIsSet;
            long processInstanceKey;
            boolean processInstanceKeyIsSet;

            Json() {
            }

            @JsonProperty(value="exceptionMessage")
            public void setExceptionMessage(String exceptionMessage) {
                this.exceptionMessage = exceptionMessage;
            }

            @JsonProperty(value="stacktrace")
            public void setStacktrace(String stacktrace) {
                this.stacktrace = stacktrace;
            }

            @JsonProperty(value="errorEventPosition")
            public void setErrorEventPosition(long errorEventPosition) {
                this.errorEventPosition = errorEventPosition;
                this.errorEventPositionIsSet = true;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            public String getExceptionMessage() {
                throw new UnsupportedOperationException();
            }

            public String getStacktrace() {
                throw new UnsupportedOperationException();
            }

            public long getErrorEventPosition() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

