/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractJobBatchRecordValue;
import io.camunda.zeebe.protocol.jackson.record.JobRecordValueBuilder;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractJobBatchRecordValue", generator="Immutables")
public final class JobBatchRecordValueBuilder {
    private String type;
    private String worker;
    private long timeout;
    private int maxJobsToActivate;
    private List<Long> jobKeys = new ArrayList<Long>();
    private boolean truncated;
    private List<JobRecordValue> jobs = new ArrayList<JobRecordValue>();

    public final JobBatchRecordValueBuilder from(JobBatchRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final JobBatchRecordValueBuilder from(AbstractJobBatchRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        JobBatchRecordValue instance;
        long bits = 0L;
        if (object instanceof JobBatchRecordValue) {
            String workerValue;
            instance = (JobBatchRecordValue)object;
            this.addAllJobKeys(instance.getJobKeys());
            if ((bits & 1L) == 0L) {
                this.addAllJobs(instance.getJobs());
                bits |= 1L;
            }
            this.truncated(instance.isTruncated());
            String typeValue = instance.getType();
            if (typeValue != null) {
                this.type(typeValue);
            }
            if ((workerValue = instance.getWorker()) != null) {
                this.worker(workerValue);
            }
            this.timeout(instance.getTimeout());
            this.maxJobsToActivate(instance.getMaxJobsToActivate());
        }
        if (object instanceof AbstractJobBatchRecordValue) {
            instance = (AbstractJobBatchRecordValue)object;
            if ((bits & 1L) == 0L) {
                this.addAllJobs(instance.getJobs());
                bits |= 1L;
            }
        }
    }

    @JsonProperty(value="type")
    public final JobBatchRecordValueBuilder type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="worker")
    public final JobBatchRecordValueBuilder worker(String worker) {
        this.worker = worker;
        return this;
    }

    @JsonProperty(value="timeout")
    public final JobBatchRecordValueBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty(value="maxJobsToActivate")
    public final JobBatchRecordValueBuilder maxJobsToActivate(int maxJobsToActivate) {
        this.maxJobsToActivate = maxJobsToActivate;
        return this;
    }

    public final JobBatchRecordValueBuilder addJobKeys(Long element) {
        this.jobKeys.add(element);
        return this;
    }

    public final JobBatchRecordValueBuilder addJobKeys(Long ... elements) {
        for (Long element : elements) {
            this.jobKeys.add(element);
        }
        return this;
    }

    @JsonProperty(value="jobKeys")
    public final JobBatchRecordValueBuilder jobKeys(Iterable<? extends Long> elements) {
        this.jobKeys.clear();
        return this.addAllJobKeys(elements);
    }

    public final JobBatchRecordValueBuilder addAllJobKeys(Iterable<? extends Long> elements) {
        for (Long l : elements) {
            this.jobKeys.add(l);
        }
        return this;
    }

    @JsonProperty(value="truncated")
    public final JobBatchRecordValueBuilder truncated(boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    public final JobBatchRecordValueBuilder addJobs(JobRecordValue element) {
        this.jobs.add(element);
        return this;
    }

    public final JobBatchRecordValueBuilder addJobs(JobRecordValue ... elements) {
        for (JobRecordValue element : elements) {
            this.jobs.add(element);
        }
        return this;
    }

    @JsonProperty(value="jobs")
    @JsonDeserialize(contentAs=JobRecordValueBuilder.ImmutableJobRecordValue.class)
    public final JobBatchRecordValueBuilder jobs(Iterable<? extends JobRecordValue> elements) {
        this.jobs.clear();
        return this.addAllJobs(elements);
    }

    public final JobBatchRecordValueBuilder addAllJobs(Iterable<? extends JobRecordValue> elements) {
        for (JobRecordValue jobRecordValue : elements) {
            this.jobs.add(jobRecordValue);
        }
        return this;
    }

    public JobBatchRecordValueBuilder clear() {
        this.type = null;
        this.worker = null;
        this.timeout = 0L;
        this.maxJobsToActivate = 0;
        this.jobKeys.clear();
        this.truncated = false;
        this.jobs.clear();
        return this;
    }

    public AbstractJobBatchRecordValue build() {
        return new ImmutableJobBatchRecordValue(this);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractJobBatchRecordValue", generator="Immutables")
    static final class ImmutableJobBatchRecordValue
    extends AbstractJobBatchRecordValue {
        private final String type;
        private final String worker;
        private final long timeout;
        private final int maxJobsToActivate;
        private final List<Long> jobKeys;
        private final boolean truncated;
        private final List<JobRecordValue> jobs;
        private transient int hashCode;

        private ImmutableJobBatchRecordValue(JobBatchRecordValueBuilder builder) {
            this.type = builder.type;
            this.worker = builder.worker;
            this.timeout = builder.timeout;
            this.maxJobsToActivate = builder.maxJobsToActivate;
            this.jobKeys = JobBatchRecordValueBuilder.createUnmodifiableList(true, builder.jobKeys);
            this.truncated = builder.truncated;
            this.jobs = JobBatchRecordValueBuilder.createUnmodifiableList(true, builder.jobs);
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="worker")
        public String getWorker() {
            return this.worker;
        }

        @JsonProperty(value="timeout")
        public long getTimeout() {
            return this.timeout;
        }

        @JsonProperty(value="maxJobsToActivate")
        public int getMaxJobsToActivate() {
            return this.maxJobsToActivate;
        }

        @JsonProperty(value="jobKeys")
        public List<Long> getJobKeys() {
            return this.jobKeys;
        }

        @JsonProperty(value="truncated")
        public boolean isTruncated() {
            return this.truncated;
        }

        @Override
        @JsonProperty(value="jobs")
        @JsonDeserialize(contentAs=JobRecordValueBuilder.ImmutableJobRecordValue.class)
        public List<JobRecordValue> getJobs() {
            return this.jobs;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableJobBatchRecordValue && this.equalTo(0, (ImmutableJobBatchRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableJobBatchRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return Objects.equals(this.type, another.type) && Objects.equals(this.worker, another.worker) && this.timeout == another.timeout && this.maxJobsToActivate == another.maxJobsToActivate && this.jobKeys.equals(another.jobKeys) && this.truncated == another.truncated && this.jobs.equals(another.jobs);
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.type);
            h += (h << 5) + Objects.hashCode(this.worker);
            h += (h << 5) + Long.hashCode(this.timeout);
            h += (h << 5) + this.maxJobsToActivate;
            h += (h << 5) + this.jobKeys.hashCode();
            h += (h << 5) + Boolean.hashCode(this.truncated);
            h += (h << 5) + this.jobs.hashCode();
            return h;
        }

        public String toString() {
            return "JobBatchRecordValue{type=" + this.type + ", worker=" + this.worker + ", timeout=" + this.timeout + ", maxJobsToActivate=" + this.maxJobsToActivate + ", jobKeys=" + this.jobKeys + ", truncated=" + this.truncated + ", jobs=" + this.jobs + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableJobBatchRecordValue fromJson(Json json) {
            JobBatchRecordValueBuilder builder = new JobBatchRecordValueBuilder();
            if (json.type != null) {
                builder.type(json.type);
            }
            if (json.worker != null) {
                builder.worker(json.worker);
            }
            if (json.timeoutIsSet) {
                builder.timeout(json.timeout);
            }
            if (json.maxJobsToActivateIsSet) {
                builder.maxJobsToActivate(json.maxJobsToActivate);
            }
            if (json.jobKeys != null) {
                builder.addAllJobKeys(json.jobKeys);
            }
            if (json.truncatedIsSet) {
                builder.truncated(json.truncated);
            }
            if (json.jobs != null) {
                builder.addAllJobs(json.jobs);
            }
            return (ImmutableJobBatchRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractJobBatchRecordValue", generator="Immutables")
        static final class Json
        extends AbstractJobBatchRecordValue {
            String type;
            String worker;
            long timeout;
            boolean timeoutIsSet;
            int maxJobsToActivate;
            boolean maxJobsToActivateIsSet;
            List<Long> jobKeys = Collections.emptyList();
            boolean truncated;
            boolean truncatedIsSet;
            List<JobRecordValue> jobs = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="type")
            public void setType(String type) {
                this.type = type;
            }

            @JsonProperty(value="worker")
            public void setWorker(String worker) {
                this.worker = worker;
            }

            @JsonProperty(value="timeout")
            public void setTimeout(long timeout) {
                this.timeout = timeout;
                this.timeoutIsSet = true;
            }

            @JsonProperty(value="maxJobsToActivate")
            public void setMaxJobsToActivate(int maxJobsToActivate) {
                this.maxJobsToActivate = maxJobsToActivate;
                this.maxJobsToActivateIsSet = true;
            }

            @JsonProperty(value="jobKeys")
            public void setJobKeys(List<Long> jobKeys) {
                this.jobKeys = jobKeys;
            }

            @JsonProperty(value="truncated")
            public void setTruncated(boolean truncated) {
                this.truncated = truncated;
                this.truncatedIsSet = true;
            }

            @JsonProperty(value="jobs")
            @JsonDeserialize(contentAs=JobRecordValueBuilder.ImmutableJobRecordValue.class)
            public void setJobs(List<JobRecordValue> jobs) {
                this.jobs = jobs;
            }

            public String getType() {
                throw new UnsupportedOperationException();
            }

            public String getWorker() {
                throw new UnsupportedOperationException();
            }

            public long getTimeout() {
                throw new UnsupportedOperationException();
            }

            public int getMaxJobsToActivate() {
                throw new UnsupportedOperationException();
            }

            public List<Long> getJobKeys() {
                throw new UnsupportedOperationException();
            }

            public boolean isTruncated() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<JobRecordValue> getJobs() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

