/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractJobRecordValue;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractJobRecordValue", generator="Immutables")
public final class JobRecordValueBuilder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private String type;
    private Map<String, String> customHeaders = new LinkedHashMap<String, String>();
    private String worker;
    private int retries;
    private long retryBackoff;
    private long recurringTime;
    private long deadline;
    private String errorMessage;
    private String elementId;
    private long elementInstanceKey;
    private String bpmnProcessId;
    private int processDefinitionVersion;
    private long processDefinitionKey;
    private String errorCode;

    public final JobRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final JobRecordValueBuilder from(JobRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final JobRecordValueBuilder from(RecordValueWithVariables instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final JobRecordValueBuilder from(AbstractJobRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        Object instance;
        long bits = 0L;
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            this.processInstanceKey(instance.getProcessInstanceKey());
        }
        if (object instanceof JobRecordValue) {
            String workerValue;
            String errorMessageValue;
            instance = (JobRecordValue)object;
            String elementIdValue = instance.getElementId();
            if (elementIdValue != null) {
                this.elementId(elementIdValue);
            }
            if ((errorMessageValue = instance.getErrorMessage()) != null) {
                this.errorMessage(errorMessageValue);
            }
            if ((bits & 1L) == 0L) {
                this.errorCode(instance.getErrorCode());
                bits |= 1L;
            }
            this.retryBackoff(instance.getRetryBackoff());
            String typeValue = instance.getType();
            if (typeValue != null) {
                this.type(typeValue);
            }
            this.recurringTime(instance.getRecurringTime());
            this.processDefinitionKey(instance.getProcessDefinitionKey());
            this.retries(instance.getRetries());
            this.elementInstanceKey(instance.getElementInstanceKey());
            String bpmnProcessIdValue = instance.getBpmnProcessId();
            if (bpmnProcessIdValue != null) {
                this.bpmnProcessId(bpmnProcessIdValue);
            }
            if ((workerValue = instance.getWorker()) != null) {
                this.worker(workerValue);
            }
            this.deadline(instance.getDeadline());
            this.putAllCustomHeaders(instance.getCustomHeaders());
            this.processDefinitionVersion(instance.getProcessDefinitionVersion());
        }
        if (object instanceof RecordValueWithVariables) {
            instance = (RecordValueWithVariables)object;
            this.putAllVariables(instance.getVariables());
        }
        if (object instanceof AbstractJobRecordValue) {
            instance = (AbstractJobRecordValue)object;
            if ((bits & 1L) == 0L) {
                this.errorCode(((AbstractJobRecordValue)instance).getErrorCode());
                bits |= 1L;
            }
        }
    }

    public final JobRecordValueBuilder putVariables(String key, Object value) {
        this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
        return this;
    }

    public final JobRecordValueBuilder putVariables(Map.Entry<String, ? extends Object> entry) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        return this;
    }

    @JsonProperty(value="variables")
    public final JobRecordValueBuilder variables(Map<String, ? extends Object> entries) {
        this.variables.clear();
        return this.putAllVariables(entries);
    }

    public final JobRecordValueBuilder putAllVariables(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        }
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final JobRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @JsonProperty(value="type")
    public final JobRecordValueBuilder type(String type) {
        this.type = type;
        return this;
    }

    public final JobRecordValueBuilder putCustomHeaders(String key, String value) {
        this.customHeaders.put(Objects.requireNonNull(key, "customHeaders key"), Objects.requireNonNull(value, "customHeaders value"));
        return this;
    }

    public final JobRecordValueBuilder putCustomHeaders(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.customHeaders.put(Objects.requireNonNull(k, "customHeaders key"), Objects.requireNonNull(v, "customHeaders value"));
        return this;
    }

    @JsonProperty(value="customHeaders")
    public final JobRecordValueBuilder customHeaders(Map<String, ? extends String> entries) {
        this.customHeaders.clear();
        return this.putAllCustomHeaders(entries);
    }

    public final JobRecordValueBuilder putAllCustomHeaders(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.customHeaders.put(Objects.requireNonNull(k, "customHeaders key"), Objects.requireNonNull(v, "customHeaders value"));
        }
        return this;
    }

    @JsonProperty(value="worker")
    public final JobRecordValueBuilder worker(String worker) {
        this.worker = worker;
        return this;
    }

    @JsonProperty(value="retries")
    public final JobRecordValueBuilder retries(int retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="retryBackoff")
    public final JobRecordValueBuilder retryBackoff(long retryBackoff) {
        this.retryBackoff = retryBackoff;
        return this;
    }

    @JsonProperty(value="recurringTime")
    public final JobRecordValueBuilder recurringTime(long recurringTime) {
        this.recurringTime = recurringTime;
        return this;
    }

    @JsonProperty(value="deadline")
    public final JobRecordValueBuilder deadline(long deadline) {
        this.deadline = deadline;
        return this;
    }

    @JsonProperty(value="errorMessage")
    public final JobRecordValueBuilder errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @JsonProperty(value="elementId")
    public final JobRecordValueBuilder elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @JsonProperty(value="elementInstanceKey")
    public final JobRecordValueBuilder elementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @JsonProperty(value="bpmnProcessId")
    public final JobRecordValueBuilder bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @JsonProperty(value="processDefinitionVersion")
    public final JobRecordValueBuilder processDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @JsonProperty(value="processDefinitionKey")
    public final JobRecordValueBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @JsonProperty(value="errorCode")
    public final JobRecordValueBuilder errorCode(String errorCode) {
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
        return this;
    }

    public JobRecordValueBuilder clear() {
        this.variables.clear();
        this.processInstanceKey = 0L;
        this.type = null;
        this.customHeaders.clear();
        this.worker = null;
        this.retries = 0;
        this.retryBackoff = 0L;
        this.recurringTime = 0L;
        this.deadline = 0L;
        this.errorMessage = null;
        this.elementId = null;
        this.elementInstanceKey = 0L;
        this.bpmnProcessId = null;
        this.processDefinitionVersion = 0;
        this.processDefinitionKey = 0L;
        this.errorCode = null;
        return this;
    }

    public AbstractJobRecordValue build() {
        return new ImmutableJobRecordValue(this);
    }

    @Generated(from="AbstractJobRecordValue", generator="Immutables")
    static final class ImmutableJobRecordValue
    extends AbstractJobRecordValue {
        private final Map<String, Object> variables;
        private final long processInstanceKey;
        private final String type;
        private final Map<String, String> customHeaders;
        private final String worker;
        private final int retries;
        private final long retryBackoff;
        private final long recurringTime;
        private final long deadline;
        private final String errorMessage;
        private final String elementId;
        private final long elementInstanceKey;
        private final String bpmnProcessId;
        private final int processDefinitionVersion;
        private final long processDefinitionKey;
        private final String errorCode;
        private transient int hashCode;

        private ImmutableJobRecordValue(JobRecordValueBuilder builder) {
            this.variables = Map.copyOf(builder.variables);
            this.processInstanceKey = builder.processInstanceKey;
            this.type = builder.type;
            this.customHeaders = Map.copyOf(builder.customHeaders);
            this.worker = builder.worker;
            this.retries = builder.retries;
            this.retryBackoff = builder.retryBackoff;
            this.recurringTime = builder.recurringTime;
            this.deadline = builder.deadline;
            this.errorMessage = builder.errorMessage;
            this.elementId = builder.elementId;
            this.elementInstanceKey = builder.elementInstanceKey;
            this.bpmnProcessId = builder.bpmnProcessId;
            this.processDefinitionVersion = builder.processDefinitionVersion;
            this.processDefinitionKey = builder.processDefinitionKey;
            this.errorCode = builder.errorCode != null ? builder.errorCode : Objects.requireNonNull(super.getErrorCode(), "errorCode");
        }

        @JsonProperty(value="variables")
        public Map<String, Object> getVariables() {
            return this.variables;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="customHeaders")
        public Map<String, String> getCustomHeaders() {
            return this.customHeaders;
        }

        @JsonProperty(value="worker")
        public String getWorker() {
            return this.worker;
        }

        @JsonProperty(value="retries")
        public int getRetries() {
            return this.retries;
        }

        @JsonProperty(value="retryBackoff")
        public long getRetryBackoff() {
            return this.retryBackoff;
        }

        @JsonProperty(value="recurringTime")
        public long getRecurringTime() {
            return this.recurringTime;
        }

        @JsonProperty(value="deadline")
        public long getDeadline() {
            return this.deadline;
        }

        @JsonProperty(value="errorMessage")
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @JsonProperty(value="elementId")
        public String getElementId() {
            return this.elementId;
        }

        @JsonProperty(value="elementInstanceKey")
        public long getElementInstanceKey() {
            return this.elementInstanceKey;
        }

        @JsonProperty(value="bpmnProcessId")
        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        @JsonProperty(value="processDefinitionVersion")
        public int getProcessDefinitionVersion() {
            return this.processDefinitionVersion;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        @Override
        @JsonProperty(value="errorCode")
        public String getErrorCode() {
            return this.errorCode;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableJobRecordValue && this.equalTo(0, (ImmutableJobRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableJobRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.type, another.type) && this.customHeaders.equals(another.customHeaders) && Objects.equals(this.worker, another.worker) && this.retries == another.retries && this.retryBackoff == another.retryBackoff && this.recurringTime == another.recurringTime && this.deadline == another.deadline && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.elementId, another.elementId) && this.elementInstanceKey == another.elementInstanceKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.processDefinitionVersion == another.processDefinitionVersion && this.processDefinitionKey == another.processDefinitionKey && this.errorCode.equals(another.errorCode);
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            h += (h << 5) + Objects.hashCode(this.type);
            h += (h << 5) + this.customHeaders.hashCode();
            h += (h << 5) + Objects.hashCode(this.worker);
            h += (h << 5) + this.retries;
            h += (h << 5) + Long.hashCode(this.retryBackoff);
            h += (h << 5) + Long.hashCode(this.recurringTime);
            h += (h << 5) + Long.hashCode(this.deadline);
            h += (h << 5) + Objects.hashCode(this.errorMessage);
            h += (h << 5) + Objects.hashCode(this.elementId);
            h += (h << 5) + Long.hashCode(this.elementInstanceKey);
            h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
            h += (h << 5) + this.processDefinitionVersion;
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            h += (h << 5) + this.errorCode.hashCode();
            return h;
        }

        public String toString() {
            return "JobRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", type=" + this.type + ", customHeaders=" + this.customHeaders + ", worker=" + this.worker + ", retries=" + this.retries + ", retryBackoff=" + this.retryBackoff + ", recurringTime=" + this.recurringTime + ", deadline=" + this.deadline + ", errorMessage=" + this.errorMessage + ", elementId=" + this.elementId + ", elementInstanceKey=" + this.elementInstanceKey + ", bpmnProcessId=" + this.bpmnProcessId + ", processDefinitionVersion=" + this.processDefinitionVersion + ", processDefinitionKey=" + this.processDefinitionKey + ", errorCode=" + this.errorCode + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableJobRecordValue fromJson(Json json) {
            JobRecordValueBuilder builder = new JobRecordValueBuilder();
            if (json.variables != null) {
                builder.putAllVariables(json.variables);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            if (json.type != null) {
                builder.type(json.type);
            }
            if (json.customHeaders != null) {
                builder.putAllCustomHeaders(json.customHeaders);
            }
            if (json.worker != null) {
                builder.worker(json.worker);
            }
            if (json.retriesIsSet) {
                builder.retries(json.retries);
            }
            if (json.retryBackoffIsSet) {
                builder.retryBackoff(json.retryBackoff);
            }
            if (json.recurringTimeIsSet) {
                builder.recurringTime(json.recurringTime);
            }
            if (json.deadlineIsSet) {
                builder.deadline(json.deadline);
            }
            if (json.errorMessage != null) {
                builder.errorMessage(json.errorMessage);
            }
            if (json.elementId != null) {
                builder.elementId(json.elementId);
            }
            if (json.elementInstanceKeyIsSet) {
                builder.elementInstanceKey(json.elementInstanceKey);
            }
            if (json.bpmnProcessId != null) {
                builder.bpmnProcessId(json.bpmnProcessId);
            }
            if (json.processDefinitionVersionIsSet) {
                builder.processDefinitionVersion(json.processDefinitionVersion);
            }
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            if (json.errorCode != null) {
                builder.errorCode(json.errorCode);
            }
            return (ImmutableJobRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractJobRecordValue", generator="Immutables")
        static final class Json
        extends AbstractJobRecordValue {
            Map<String, Object> variables = Map.of();
            long processInstanceKey;
            boolean processInstanceKeyIsSet;
            String type;
            Map<String, String> customHeaders = Map.of();
            String worker;
            int retries;
            boolean retriesIsSet;
            long retryBackoff;
            boolean retryBackoffIsSet;
            long recurringTime;
            boolean recurringTimeIsSet;
            long deadline;
            boolean deadlineIsSet;
            String errorMessage;
            String elementId;
            long elementInstanceKey;
            boolean elementInstanceKeyIsSet;
            String bpmnProcessId;
            int processDefinitionVersion;
            boolean processDefinitionVersionIsSet;
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;
            String errorCode;

            Json() {
            }

            @JsonProperty(value="variables")
            public void setVariables(Map<String, Object> variables) {
                this.variables = variables;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            @JsonProperty(value="type")
            public void setType(String type) {
                this.type = type;
            }

            @JsonProperty(value="customHeaders")
            public void setCustomHeaders(Map<String, String> customHeaders) {
                this.customHeaders = customHeaders;
            }

            @JsonProperty(value="worker")
            public void setWorker(String worker) {
                this.worker = worker;
            }

            @JsonProperty(value="retries")
            public void setRetries(int retries) {
                this.retries = retries;
                this.retriesIsSet = true;
            }

            @JsonProperty(value="retryBackoff")
            public void setRetryBackoff(long retryBackoff) {
                this.retryBackoff = retryBackoff;
                this.retryBackoffIsSet = true;
            }

            @JsonProperty(value="recurringTime")
            public void setRecurringTime(long recurringTime) {
                this.recurringTime = recurringTime;
                this.recurringTimeIsSet = true;
            }

            @JsonProperty(value="deadline")
            public void setDeadline(long deadline) {
                this.deadline = deadline;
                this.deadlineIsSet = true;
            }

            @JsonProperty(value="errorMessage")
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @JsonProperty(value="elementId")
            public void setElementId(String elementId) {
                this.elementId = elementId;
            }

            @JsonProperty(value="elementInstanceKey")
            public void setElementInstanceKey(long elementInstanceKey) {
                this.elementInstanceKey = elementInstanceKey;
                this.elementInstanceKeyIsSet = true;
            }

            @JsonProperty(value="bpmnProcessId")
            public void setBpmnProcessId(String bpmnProcessId) {
                this.bpmnProcessId = bpmnProcessId;
            }

            @JsonProperty(value="processDefinitionVersion")
            public void setProcessDefinitionVersion(int processDefinitionVersion) {
                this.processDefinitionVersion = processDefinitionVersion;
                this.processDefinitionVersionIsSet = true;
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            @JsonProperty(value="errorCode")
            public void setErrorCode(String errorCode) {
                this.errorCode = errorCode;
            }

            public Map<String, Object> getVariables() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public String getType() {
                throw new UnsupportedOperationException();
            }

            public Map<String, String> getCustomHeaders() {
                throw new UnsupportedOperationException();
            }

            public String getWorker() {
                throw new UnsupportedOperationException();
            }

            public int getRetries() {
                throw new UnsupportedOperationException();
            }

            public long getRetryBackoff() {
                throw new UnsupportedOperationException();
            }

            public long getRecurringTime() {
                throw new UnsupportedOperationException();
            }

            public long getDeadline() {
                throw new UnsupportedOperationException();
            }

            public String getErrorMessage() {
                throw new UnsupportedOperationException();
            }

            public String getElementId() {
                throw new UnsupportedOperationException();
            }

            public long getElementInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public String getBpmnProcessId() {
                throw new UnsupportedOperationException();
            }

            public int getProcessDefinitionVersion() {
                throw new UnsupportedOperationException();
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getErrorCode() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

