/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractMessageRecordValue;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractMessageRecordValue", generator="Immutables")
public final class MessageRecordValueBuilder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String name;
    private String correlationKey;
    private String messageId;
    private long timeToLive;
    private long deadline;

    public final MessageRecordValueBuilder from(MessageRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final MessageRecordValueBuilder from(RecordValueWithVariables instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final MessageRecordValueBuilder from(AbstractMessageRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        MessageRecordValue instance;
        if (object instanceof MessageRecordValue) {
            String correlationKeyValue;
            instance = (MessageRecordValue)object;
            String nameValue = instance.getName();
            if (nameValue != null) {
                this.name(nameValue);
            }
            this.timeToLive(instance.getTimeToLive());
            String messageIdValue = instance.getMessageId();
            if (messageIdValue != null) {
                this.messageId(messageIdValue);
            }
            if ((correlationKeyValue = instance.getCorrelationKey()) != null) {
                this.correlationKey(correlationKeyValue);
            }
            this.deadline(instance.getDeadline());
        }
        if (object instanceof RecordValueWithVariables) {
            instance = (RecordValueWithVariables)object;
            this.putAllVariables(instance.getVariables());
        }
    }

    public final MessageRecordValueBuilder putVariables(String key, Object value) {
        this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
        return this;
    }

    public final MessageRecordValueBuilder putVariables(Map.Entry<String, ? extends Object> entry) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        return this;
    }

    @JsonProperty(value="variables")
    public final MessageRecordValueBuilder variables(Map<String, ? extends Object> entries) {
        this.variables.clear();
        return this.putAllVariables(entries);
    }

    public final MessageRecordValueBuilder putAllVariables(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        }
        return this;
    }

    @JsonProperty(value="name")
    public final MessageRecordValueBuilder name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="correlationKey")
    public final MessageRecordValueBuilder correlationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    @JsonProperty(value="messageId")
    public final MessageRecordValueBuilder messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @JsonProperty(value="timeToLive")
    public final MessageRecordValueBuilder timeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    @JsonProperty(value="deadline")
    public final MessageRecordValueBuilder deadline(long deadline) {
        this.deadline = deadline;
        return this;
    }

    public MessageRecordValueBuilder clear() {
        this.variables.clear();
        this.name = null;
        this.correlationKey = null;
        this.messageId = null;
        this.timeToLive = 0L;
        this.deadline = 0L;
        return this;
    }

    public AbstractMessageRecordValue build() {
        return new ImmutableMessageRecordValue(this);
    }

    @Generated(from="AbstractMessageRecordValue", generator="Immutables")
    static final class ImmutableMessageRecordValue
    extends AbstractMessageRecordValue {
        private final Map<String, Object> variables;
        private final String name;
        private final String correlationKey;
        private final String messageId;
        private final long timeToLive;
        private final long deadline;
        private transient int hashCode;

        private ImmutableMessageRecordValue(MessageRecordValueBuilder builder) {
            this.variables = Map.copyOf(builder.variables);
            this.name = builder.name;
            this.correlationKey = builder.correlationKey;
            this.messageId = builder.messageId;
            this.timeToLive = builder.timeToLive;
            this.deadline = builder.deadline;
        }

        @JsonProperty(value="variables")
        public Map<String, Object> getVariables() {
            return this.variables;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="correlationKey")
        public String getCorrelationKey() {
            return this.correlationKey;
        }

        @JsonProperty(value="messageId")
        public String getMessageId() {
            return this.messageId;
        }

        @JsonProperty(value="timeToLive")
        public long getTimeToLive() {
            return this.timeToLive;
        }

        @JsonProperty(value="deadline")
        public long getDeadline() {
            return this.deadline;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableMessageRecordValue && this.equalTo(0, (ImmutableMessageRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableMessageRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.variables.equals(another.variables) && Objects.equals(this.name, another.name) && Objects.equals(this.correlationKey, another.correlationKey) && Objects.equals(this.messageId, another.messageId) && this.timeToLive == another.timeToLive && this.deadline == another.deadline;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.correlationKey);
            h += (h << 5) + Objects.hashCode(this.messageId);
            h += (h << 5) + Long.hashCode(this.timeToLive);
            h += (h << 5) + Long.hashCode(this.deadline);
            return h;
        }

        public String toString() {
            return "MessageRecordValue{variables=" + this.variables + ", name=" + this.name + ", correlationKey=" + this.correlationKey + ", messageId=" + this.messageId + ", timeToLive=" + this.timeToLive + ", deadline=" + this.deadline + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableMessageRecordValue fromJson(Json json) {
            MessageRecordValueBuilder builder = new MessageRecordValueBuilder();
            if (json.variables != null) {
                builder.putAllVariables(json.variables);
            }
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.correlationKey != null) {
                builder.correlationKey(json.correlationKey);
            }
            if (json.messageId != null) {
                builder.messageId(json.messageId);
            }
            if (json.timeToLiveIsSet) {
                builder.timeToLive(json.timeToLive);
            }
            if (json.deadlineIsSet) {
                builder.deadline(json.deadline);
            }
            return (ImmutableMessageRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractMessageRecordValue", generator="Immutables")
        static final class Json
        extends AbstractMessageRecordValue {
            Map<String, Object> variables = Map.of();
            String name;
            String correlationKey;
            String messageId;
            long timeToLive;
            boolean timeToLiveIsSet;
            long deadline;
            boolean deadlineIsSet;

            Json() {
            }

            @JsonProperty(value="variables")
            public void setVariables(Map<String, Object> variables) {
                this.variables = variables;
            }

            @JsonProperty(value="name")
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="correlationKey")
            public void setCorrelationKey(String correlationKey) {
                this.correlationKey = correlationKey;
            }

            @JsonProperty(value="messageId")
            public void setMessageId(String messageId) {
                this.messageId = messageId;
            }

            @JsonProperty(value="timeToLive")
            public void setTimeToLive(long timeToLive) {
                this.timeToLive = timeToLive;
                this.timeToLiveIsSet = true;
            }

            @JsonProperty(value="deadline")
            public void setDeadline(long deadline) {
                this.deadline = deadline;
                this.deadlineIsSet = true;
            }

            public Map<String, Object> getVariables() {
                throw new UnsupportedOperationException();
            }

            public String getName() {
                throw new UnsupportedOperationException();
            }

            public String getCorrelationKey() {
                throw new UnsupportedOperationException();
            }

            public String getMessageId() {
                throw new UnsupportedOperationException();
            }

            public long getTimeToLive() {
                throw new UnsupportedOperationException();
            }

            public long getDeadline() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

