/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractProcess;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcess", generator="Immutables")
public final class ProcessBuilder {
    private String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private String resourceName;
    private byte[] checksum;
    private boolean duplicate;
    private byte[] resource;

    public final ProcessBuilder from(Process instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessBuilder from(ProcessMetadataValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessBuilder from(AbstractProcess instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        Process instance;
        byte[] resourceValue;
        if (object instanceof Process && (resourceValue = (instance = (Process)object).getResource()) != null) {
            this.resource(resourceValue);
        }
        if (object instanceof ProcessMetadataValue) {
            String bpmnProcessIdValue;
            String resourceNameValue;
            instance = (ProcessMetadataValue)object;
            byte[] checksumValue = instance.getChecksum();
            if (checksumValue != null) {
                this.checksum(checksumValue);
            }
            if ((resourceNameValue = instance.getResourceName()) != null) {
                this.resourceName(resourceNameValue);
            }
            if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                this.bpmnProcessId(bpmnProcessIdValue);
            }
            this.duplicate(instance.isDuplicate());
            this.version(instance.getVersion());
            this.processDefinitionKey(instance.getProcessDefinitionKey());
        }
    }

    @JsonProperty(value="bpmnProcessId")
    public final ProcessBuilder bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @JsonProperty(value="version")
    public final ProcessBuilder version(int version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="processDefinitionKey")
    public final ProcessBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @JsonProperty(value="resourceName")
    public final ProcessBuilder resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @JsonProperty(value="checksum")
    public final ProcessBuilder checksum(byte ... checksum) {
        this.checksum = checksum;
        return this;
    }

    @JsonProperty(value="duplicate")
    public final ProcessBuilder duplicate(boolean duplicate) {
        this.duplicate = duplicate;
        return this;
    }

    @JsonProperty(value="resource")
    public final ProcessBuilder resource(byte ... resource) {
        this.resource = resource;
        return this;
    }

    public ProcessBuilder clear() {
        this.bpmnProcessId = null;
        this.version = 0;
        this.processDefinitionKey = 0L;
        this.resourceName = null;
        this.checksum = null;
        this.duplicate = false;
        this.resource = null;
        return this;
    }

    public AbstractProcess build() {
        return new ImmutableProcess(this);
    }

    @Generated(from="AbstractProcess", generator="Immutables")
    static final class ImmutableProcess
    extends AbstractProcess {
        private final String bpmnProcessId;
        private final int version;
        private final long processDefinitionKey;
        private final String resourceName;
        private final byte[] checksum;
        private final boolean duplicate;
        private final byte[] resource;
        private transient int hashCode;

        private ImmutableProcess(ProcessBuilder builder) {
            this.bpmnProcessId = builder.bpmnProcessId;
            this.version = builder.version;
            this.processDefinitionKey = builder.processDefinitionKey;
            this.resourceName = builder.resourceName;
            this.checksum = builder.checksum;
            this.duplicate = builder.duplicate;
            this.resource = builder.resource;
        }

        @JsonProperty(value="bpmnProcessId")
        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        @JsonProperty(value="version")
        public int getVersion() {
            return this.version;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        @JsonProperty(value="resourceName")
        public String getResourceName() {
            return this.resourceName;
        }

        @JsonProperty(value="checksum")
        public byte[] getChecksum() {
            return this.checksum;
        }

        @JsonProperty(value="duplicate")
        public boolean isDuplicate() {
            return this.duplicate;
        }

        @JsonProperty(value="resource")
        public byte[] getResource() {
            return this.resource;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableProcess && this.equalTo(0, (ImmutableProcess)another);
        }

        private boolean equalTo(int synthetic, ImmutableProcess another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && Objects.equals(this.resourceName, another.resourceName) && Arrays.equals(this.checksum, another.checksum) && this.duplicate == another.duplicate && Arrays.equals(this.resource, another.resource);
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
            h += (h << 5) + this.version;
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            h += (h << 5) + Objects.hashCode(this.resourceName);
            h += (h << 5) + Arrays.hashCode(this.checksum);
            h += (h << 5) + Boolean.hashCode(this.duplicate);
            h += (h << 5) + Arrays.hashCode(this.resource);
            return h;
        }

        public String toString() {
            return "Process{bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", resourceName=" + this.resourceName + ", checksum=" + Arrays.toString(this.checksum) + ", duplicate=" + this.duplicate + ", resource=" + Arrays.toString(this.resource) + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableProcess fromJson(Json json) {
            ProcessBuilder builder = new ProcessBuilder();
            if (json.bpmnProcessId != null) {
                builder.bpmnProcessId(json.bpmnProcessId);
            }
            if (json.versionIsSet) {
                builder.version(json.version);
            }
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            if (json.resourceName != null) {
                builder.resourceName(json.resourceName);
            }
            if (json.checksum != null) {
                builder.checksum(json.checksum);
            }
            if (json.duplicateIsSet) {
                builder.duplicate(json.duplicate);
            }
            if (json.resource != null) {
                builder.resource(json.resource);
            }
            return (ImmutableProcess)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractProcess", generator="Immutables")
        static final class Json
        extends AbstractProcess {
            String bpmnProcessId;
            int version;
            boolean versionIsSet;
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;
            String resourceName;
            byte[] checksum;
            boolean duplicate;
            boolean duplicateIsSet;
            byte[] resource;

            Json() {
            }

            @JsonProperty(value="bpmnProcessId")
            public void setBpmnProcessId(String bpmnProcessId) {
                this.bpmnProcessId = bpmnProcessId;
            }

            @JsonProperty(value="version")
            public void setVersion(int version) {
                this.version = version;
                this.versionIsSet = true;
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            @JsonProperty(value="resourceName")
            public void setResourceName(String resourceName) {
                this.resourceName = resourceName;
            }

            @JsonProperty(value="checksum")
            public void setChecksum(byte[] checksum) {
                this.checksum = checksum;
            }

            @JsonProperty(value="duplicate")
            public void setDuplicate(boolean duplicate) {
                this.duplicate = duplicate;
                this.duplicateIsSet = true;
            }

            @JsonProperty(value="resource")
            public void setResource(byte[] resource) {
                this.resource = resource;
            }

            public String getBpmnProcessId() {
                throw new UnsupportedOperationException();
            }

            public int getVersion() {
                throw new UnsupportedOperationException();
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }

            public String getResourceName() {
                throw new UnsupportedOperationException();
            }

            public byte[] getChecksum() {
                throw new UnsupportedOperationException();
            }

            public boolean isDuplicate() {
                throw new UnsupportedOperationException();
            }

            public byte[] getResource() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

