/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessEventRecordValue", generator="Immutables")
public final class ProcessEventRecordValueBuilder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private long scopeKey;
    private String targetElementId;
    private long processDefinitionKey;

    public final ProcessEventRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessEventRecordValueBuilder from(ProcessEventRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessEventRecordValueBuilder from(RecordValueWithVariables instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessEventRecordValueBuilder from(AbstractProcessEventRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        ProcessInstanceRelated instance;
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            this.processInstanceKey(instance.getProcessInstanceKey());
        }
        if (object instanceof ProcessEventRecordValue) {
            instance = (ProcessEventRecordValue)object;
            this.scopeKey(instance.getScopeKey());
            String targetElementIdValue = instance.getTargetElementId();
            if (targetElementIdValue != null) {
                this.targetElementId(targetElementIdValue);
            }
            this.processDefinitionKey(instance.getProcessDefinitionKey());
        }
        if (object instanceof RecordValueWithVariables) {
            instance = (RecordValueWithVariables)object;
            this.putAllVariables(instance.getVariables());
        }
    }

    public final ProcessEventRecordValueBuilder putVariables(String key, Object value) {
        this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
        return this;
    }

    public final ProcessEventRecordValueBuilder putVariables(Map.Entry<String, ? extends Object> entry) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        return this;
    }

    @JsonProperty(value="variables")
    public final ProcessEventRecordValueBuilder variables(Map<String, ? extends Object> entries) {
        this.variables.clear();
        return this.putAllVariables(entries);
    }

    public final ProcessEventRecordValueBuilder putAllVariables(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        }
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final ProcessEventRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @JsonProperty(value="scopeKey")
    public final ProcessEventRecordValueBuilder scopeKey(long scopeKey) {
        this.scopeKey = scopeKey;
        return this;
    }

    @JsonProperty(value="targetElementId")
    public final ProcessEventRecordValueBuilder targetElementId(String targetElementId) {
        this.targetElementId = targetElementId;
        return this;
    }

    @JsonProperty(value="processDefinitionKey")
    public final ProcessEventRecordValueBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public ProcessEventRecordValueBuilder clear() {
        this.variables.clear();
        this.processInstanceKey = 0L;
        this.scopeKey = 0L;
        this.targetElementId = null;
        this.processDefinitionKey = 0L;
        return this;
    }

    public AbstractProcessEventRecordValue build() {
        return new ImmutableProcessEventRecordValue(this);
    }

    @Generated(from="AbstractProcessEventRecordValue", generator="Immutables")
    static final class ImmutableProcessEventRecordValue
    extends AbstractProcessEventRecordValue {
        private final Map<String, Object> variables;
        private final long processInstanceKey;
        private final long scopeKey;
        private final String targetElementId;
        private final long processDefinitionKey;
        private transient int hashCode;

        private ImmutableProcessEventRecordValue(ProcessEventRecordValueBuilder builder) {
            this.variables = Map.copyOf(builder.variables);
            this.processInstanceKey = builder.processInstanceKey;
            this.scopeKey = builder.scopeKey;
            this.targetElementId = builder.targetElementId;
            this.processDefinitionKey = builder.processDefinitionKey;
        }

        @JsonProperty(value="variables")
        public Map<String, Object> getVariables() {
            return this.variables;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @JsonProperty(value="scopeKey")
        public long getScopeKey() {
            return this.scopeKey;
        }

        @JsonProperty(value="targetElementId")
        public String getTargetElementId() {
            return this.targetElementId;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableProcessEventRecordValue && this.equalTo(0, (ImmutableProcessEventRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableProcessEventRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && this.scopeKey == another.scopeKey && Objects.equals(this.targetElementId, another.targetElementId) && this.processDefinitionKey == another.processDefinitionKey;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            h += (h << 5) + Long.hashCode(this.scopeKey);
            h += (h << 5) + Objects.hashCode(this.targetElementId);
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            return h;
        }

        public String toString() {
            return "ProcessEventRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", scopeKey=" + this.scopeKey + ", targetElementId=" + this.targetElementId + ", processDefinitionKey=" + this.processDefinitionKey + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableProcessEventRecordValue fromJson(Json json) {
            ProcessEventRecordValueBuilder builder = new ProcessEventRecordValueBuilder();
            if (json.variables != null) {
                builder.putAllVariables(json.variables);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            if (json.scopeKeyIsSet) {
                builder.scopeKey(json.scopeKey);
            }
            if (json.targetElementId != null) {
                builder.targetElementId(json.targetElementId);
            }
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            return (ImmutableProcessEventRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractProcessEventRecordValue", generator="Immutables")
        static final class Json
        extends AbstractProcessEventRecordValue {
            Map<String, Object> variables = Map.of();
            long processInstanceKey;
            boolean processInstanceKeyIsSet;
            long scopeKey;
            boolean scopeKeyIsSet;
            String targetElementId;
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;

            Json() {
            }

            @JsonProperty(value="variables")
            public void setVariables(Map<String, Object> variables) {
                this.variables = variables;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            @JsonProperty(value="scopeKey")
            public void setScopeKey(long scopeKey) {
                this.scopeKey = scopeKey;
                this.scopeKeyIsSet = true;
            }

            @JsonProperty(value="targetElementId")
            public void setTargetElementId(String targetElementId) {
                this.targetElementId = targetElementId;
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            public Map<String, Object> getVariables() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public long getScopeKey() {
                throw new UnsupportedOperationException();
            }

            public String getTargetElementId() {
                throw new UnsupportedOperationException();
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

