/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessInstanceCreationRecordValue", generator="Immutables")
public final class ProcessInstanceCreationRecordValueBuilder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private String bpmnProcessId;
    private int version;
    private long processDefinitionKey;

    public final ProcessInstanceCreationRecordValueBuilder from(ProcessInstanceCreationRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceCreationRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceCreationRecordValueBuilder from(RecordValueWithVariables instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceCreationRecordValueBuilder from(AbstractProcessInstanceCreationRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        ProcessInstanceCreationRecordValue instance;
        if (object instanceof ProcessInstanceCreationRecordValue) {
            instance = (ProcessInstanceCreationRecordValue)object;
            this.version(instance.getVersion());
            String bpmnProcessIdValue = instance.getBpmnProcessId();
            if (bpmnProcessIdValue != null) {
                this.bpmnProcessId(bpmnProcessIdValue);
            }
            this.processDefinitionKey(instance.getProcessDefinitionKey());
        }
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            this.processInstanceKey(instance.getProcessInstanceKey());
        }
        if (object instanceof RecordValueWithVariables) {
            instance = (RecordValueWithVariables)object;
            this.putAllVariables(instance.getVariables());
        }
    }

    public final ProcessInstanceCreationRecordValueBuilder putVariables(String key, Object value) {
        this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
        return this;
    }

    public final ProcessInstanceCreationRecordValueBuilder putVariables(Map.Entry<String, ? extends Object> entry) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        return this;
    }

    @JsonProperty(value="variables")
    public final ProcessInstanceCreationRecordValueBuilder variables(Map<String, ? extends Object> entries) {
        this.variables.clear();
        return this.putAllVariables(entries);
    }

    public final ProcessInstanceCreationRecordValueBuilder putAllVariables(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        }
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final ProcessInstanceCreationRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @JsonProperty(value="bpmnProcessId")
    public final ProcessInstanceCreationRecordValueBuilder bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @JsonProperty(value="version")
    public final ProcessInstanceCreationRecordValueBuilder version(int version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="processDefinitionKey")
    public final ProcessInstanceCreationRecordValueBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public ProcessInstanceCreationRecordValueBuilder clear() {
        this.variables.clear();
        this.processInstanceKey = 0L;
        this.bpmnProcessId = null;
        this.version = 0;
        this.processDefinitionKey = 0L;
        return this;
    }

    public AbstractProcessInstanceCreationRecordValue build() {
        return new ImmutableProcessInstanceCreationRecordValue(this);
    }

    @Generated(from="AbstractProcessInstanceCreationRecordValue", generator="Immutables")
    static final class ImmutableProcessInstanceCreationRecordValue
    extends AbstractProcessInstanceCreationRecordValue {
        private final Map<String, Object> variables;
        private final long processInstanceKey;
        private final String bpmnProcessId;
        private final int version;
        private final long processDefinitionKey;
        private transient int hashCode;

        private ImmutableProcessInstanceCreationRecordValue(ProcessInstanceCreationRecordValueBuilder builder) {
            this.variables = Map.copyOf(builder.variables);
            this.processInstanceKey = builder.processInstanceKey;
            this.bpmnProcessId = builder.bpmnProcessId;
            this.version = builder.version;
            this.processDefinitionKey = builder.processDefinitionKey;
        }

        @JsonProperty(value="variables")
        public Map<String, Object> getVariables() {
            return this.variables;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @JsonProperty(value="bpmnProcessId")
        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        @JsonProperty(value="version")
        public int getVersion() {
            return this.version;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableProcessInstanceCreationRecordValue && this.equalTo(0, (ImmutableProcessInstanceCreationRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableProcessInstanceCreationRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
            h += (h << 5) + this.version;
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            return h;
        }

        public String toString() {
            return "ProcessInstanceCreationRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableProcessInstanceCreationRecordValue fromJson(Json json) {
            ProcessInstanceCreationRecordValueBuilder builder = new ProcessInstanceCreationRecordValueBuilder();
            if (json.variables != null) {
                builder.putAllVariables(json.variables);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            if (json.bpmnProcessId != null) {
                builder.bpmnProcessId(json.bpmnProcessId);
            }
            if (json.versionIsSet) {
                builder.version(json.version);
            }
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            return (ImmutableProcessInstanceCreationRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractProcessInstanceCreationRecordValue", generator="Immutables")
        static final class Json
        extends AbstractProcessInstanceCreationRecordValue {
            Map<String, Object> variables = Map.of();
            long processInstanceKey;
            boolean processInstanceKeyIsSet;
            String bpmnProcessId;
            int version;
            boolean versionIsSet;
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;

            Json() {
            }

            @JsonProperty(value="variables")
            public void setVariables(Map<String, Object> variables) {
                this.variables = variables;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            @JsonProperty(value="bpmnProcessId")
            public void setBpmnProcessId(String bpmnProcessId) {
                this.bpmnProcessId = bpmnProcessId;
            }

            @JsonProperty(value="version")
            public void setVersion(int version) {
                this.version = version;
                this.versionIsSet = true;
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            public Map<String, Object> getVariables() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public String getBpmnProcessId() {
                throw new UnsupportedOperationException();
            }

            public int getVersion() {
                throw new UnsupportedOperationException();
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

