/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessInstanceRecordValue", generator="Immutables")
public final class ProcessInstanceRecordValueBuilder {
    private String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private long processInstanceKey;
    private String elementId;
    private long flowScopeKey;
    private BpmnElementType bpmnElementType;
    private long parentProcessInstanceKey;
    private long parentElementInstanceKey;

    public final ProcessInstanceRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceRecordValueBuilder from(ProcessInstanceRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceRecordValueBuilder from(AbstractProcessInstanceRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        ProcessInstanceRelated instance;
        long bits = 0L;
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
        }
        if (object instanceof ProcessInstanceRecordValue) {
            instance = (ProcessInstanceRecordValue)object;
            String elementIdValue = instance.getElementId();
            if (elementIdValue != null) {
                this.elementId(elementIdValue);
            }
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
            this.flowScopeKey(instance.getFlowScopeKey());
            this.parentElementInstanceKey(instance.getParentElementInstanceKey());
            String bpmnProcessIdValue = instance.getBpmnProcessId();
            if (bpmnProcessIdValue != null) {
                this.bpmnProcessId(bpmnProcessIdValue);
            }
            this.version(instance.getVersion());
            BpmnElementType bpmnElementTypeValue = instance.getBpmnElementType();
            if (bpmnElementTypeValue != null) {
                this.bpmnElementType(bpmnElementTypeValue);
            }
            this.parentProcessInstanceKey(instance.getParentProcessInstanceKey());
            this.processDefinitionKey(instance.getProcessDefinitionKey());
        }
    }

    @JsonProperty(value="bpmnProcessId")
    public final ProcessInstanceRecordValueBuilder bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @JsonProperty(value="version")
    public final ProcessInstanceRecordValueBuilder version(int version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="processDefinitionKey")
    public final ProcessInstanceRecordValueBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final ProcessInstanceRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @JsonProperty(value="elementId")
    public final ProcessInstanceRecordValueBuilder elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @JsonProperty(value="flowScopeKey")
    public final ProcessInstanceRecordValueBuilder flowScopeKey(long flowScopeKey) {
        this.flowScopeKey = flowScopeKey;
        return this;
    }

    @JsonProperty(value="bpmnElementType")
    public final ProcessInstanceRecordValueBuilder bpmnElementType(BpmnElementType bpmnElementType) {
        this.bpmnElementType = bpmnElementType;
        return this;
    }

    @JsonProperty(value="parentProcessInstanceKey")
    public final ProcessInstanceRecordValueBuilder parentProcessInstanceKey(long parentProcessInstanceKey) {
        this.parentProcessInstanceKey = parentProcessInstanceKey;
        return this;
    }

    @JsonProperty(value="parentElementInstanceKey")
    public final ProcessInstanceRecordValueBuilder parentElementInstanceKey(long parentElementInstanceKey) {
        this.parentElementInstanceKey = parentElementInstanceKey;
        return this;
    }

    public ProcessInstanceRecordValueBuilder clear() {
        this.bpmnProcessId = null;
        this.version = 0;
        this.processDefinitionKey = 0L;
        this.processInstanceKey = 0L;
        this.elementId = null;
        this.flowScopeKey = 0L;
        this.bpmnElementType = null;
        this.parentProcessInstanceKey = 0L;
        this.parentElementInstanceKey = 0L;
        return this;
    }

    public AbstractProcessInstanceRecordValue build() {
        return new ImmutableProcessInstanceRecordValue(this);
    }

    @Generated(from="AbstractProcessInstanceRecordValue", generator="Immutables")
    static final class ImmutableProcessInstanceRecordValue
    extends AbstractProcessInstanceRecordValue {
        private final String bpmnProcessId;
        private final int version;
        private final long processDefinitionKey;
        private final long processInstanceKey;
        private final String elementId;
        private final long flowScopeKey;
        private final BpmnElementType bpmnElementType;
        private final long parentProcessInstanceKey;
        private final long parentElementInstanceKey;
        private transient int hashCode;

        private ImmutableProcessInstanceRecordValue(ProcessInstanceRecordValueBuilder builder) {
            this.bpmnProcessId = builder.bpmnProcessId;
            this.version = builder.version;
            this.processDefinitionKey = builder.processDefinitionKey;
            this.processInstanceKey = builder.processInstanceKey;
            this.elementId = builder.elementId;
            this.flowScopeKey = builder.flowScopeKey;
            this.bpmnElementType = builder.bpmnElementType;
            this.parentProcessInstanceKey = builder.parentProcessInstanceKey;
            this.parentElementInstanceKey = builder.parentElementInstanceKey;
        }

        @JsonProperty(value="bpmnProcessId")
        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        @JsonProperty(value="version")
        public int getVersion() {
            return this.version;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @JsonProperty(value="elementId")
        public String getElementId() {
            return this.elementId;
        }

        @JsonProperty(value="flowScopeKey")
        public long getFlowScopeKey() {
            return this.flowScopeKey;
        }

        @JsonProperty(value="bpmnElementType")
        public BpmnElementType getBpmnElementType() {
            return this.bpmnElementType;
        }

        @JsonProperty(value="parentProcessInstanceKey")
        public long getParentProcessInstanceKey() {
            return this.parentProcessInstanceKey;
        }

        @JsonProperty(value="parentElementInstanceKey")
        public long getParentElementInstanceKey() {
            return this.parentElementInstanceKey;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableProcessInstanceRecordValue && this.equalTo(0, (ImmutableProcessInstanceRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableProcessInstanceRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.elementId, another.elementId) && this.flowScopeKey == another.flowScopeKey && Objects.equals(this.bpmnElementType, another.bpmnElementType) && this.parentProcessInstanceKey == another.parentProcessInstanceKey && this.parentElementInstanceKey == another.parentElementInstanceKey;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
            h += (h << 5) + this.version;
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            h += (h << 5) + Objects.hashCode(this.elementId);
            h += (h << 5) + Long.hashCode(this.flowScopeKey);
            h += (h << 5) + Objects.hashCode(this.bpmnElementType);
            h += (h << 5) + Long.hashCode(this.parentProcessInstanceKey);
            h += (h << 5) + Long.hashCode(this.parentElementInstanceKey);
            return h;
        }

        public String toString() {
            return "ProcessInstanceRecordValue{bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + ", elementId=" + this.elementId + ", flowScopeKey=" + this.flowScopeKey + ", bpmnElementType=" + this.bpmnElementType + ", parentProcessInstanceKey=" + this.parentProcessInstanceKey + ", parentElementInstanceKey=" + this.parentElementInstanceKey + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableProcessInstanceRecordValue fromJson(Json json) {
            ProcessInstanceRecordValueBuilder builder = new ProcessInstanceRecordValueBuilder();
            if (json.bpmnProcessId != null) {
                builder.bpmnProcessId(json.bpmnProcessId);
            }
            if (json.versionIsSet) {
                builder.version(json.version);
            }
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            if (json.elementId != null) {
                builder.elementId(json.elementId);
            }
            if (json.flowScopeKeyIsSet) {
                builder.flowScopeKey(json.flowScopeKey);
            }
            if (json.bpmnElementType != null) {
                builder.bpmnElementType(json.bpmnElementType);
            }
            if (json.parentProcessInstanceKeyIsSet) {
                builder.parentProcessInstanceKey(json.parentProcessInstanceKey);
            }
            if (json.parentElementInstanceKeyIsSet) {
                builder.parentElementInstanceKey(json.parentElementInstanceKey);
            }
            return (ImmutableProcessInstanceRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractProcessInstanceRecordValue", generator="Immutables")
        static final class Json
        extends AbstractProcessInstanceRecordValue {
            String bpmnProcessId;
            int version;
            boolean versionIsSet;
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;
            long processInstanceKey;
            boolean processInstanceKeyIsSet;
            String elementId;
            long flowScopeKey;
            boolean flowScopeKeyIsSet;
            BpmnElementType bpmnElementType;
            long parentProcessInstanceKey;
            boolean parentProcessInstanceKeyIsSet;
            long parentElementInstanceKey;
            boolean parentElementInstanceKeyIsSet;

            Json() {
            }

            @JsonProperty(value="bpmnProcessId")
            public void setBpmnProcessId(String bpmnProcessId) {
                this.bpmnProcessId = bpmnProcessId;
            }

            @JsonProperty(value="version")
            public void setVersion(int version) {
                this.version = version;
                this.versionIsSet = true;
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            @JsonProperty(value="elementId")
            public void setElementId(String elementId) {
                this.elementId = elementId;
            }

            @JsonProperty(value="flowScopeKey")
            public void setFlowScopeKey(long flowScopeKey) {
                this.flowScopeKey = flowScopeKey;
                this.flowScopeKeyIsSet = true;
            }

            @JsonProperty(value="bpmnElementType")
            public void setBpmnElementType(BpmnElementType bpmnElementType) {
                this.bpmnElementType = bpmnElementType;
            }

            @JsonProperty(value="parentProcessInstanceKey")
            public void setParentProcessInstanceKey(long parentProcessInstanceKey) {
                this.parentProcessInstanceKey = parentProcessInstanceKey;
                this.parentProcessInstanceKeyIsSet = true;
            }

            @JsonProperty(value="parentElementInstanceKey")
            public void setParentElementInstanceKey(long parentElementInstanceKey) {
                this.parentElementInstanceKey = parentElementInstanceKey;
                this.parentElementInstanceKeyIsSet = true;
            }

            public String getBpmnProcessId() {
                throw new UnsupportedOperationException();
            }

            public int getVersion() {
                throw new UnsupportedOperationException();
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public String getElementId() {
                throw new UnsupportedOperationException();
            }

            public long getFlowScopeKey() {
                throw new UnsupportedOperationException();
            }

            public BpmnElementType getBpmnElementType() {
                throw new UnsupportedOperationException();
            }

            public long getParentProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public long getParentElementInstanceKey() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

