/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractProcessInstanceResultRecordValue;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessInstanceResultRecordValue", generator="Immutables")
public final class ProcessInstanceResultRecordValueBuilder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private long processInstanceKey;

    public final ProcessInstanceResultRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceResultRecordValueBuilder from(ProcessInstanceResultRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceResultRecordValueBuilder from(RecordValueWithVariables instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessInstanceResultRecordValueBuilder from(AbstractProcessInstanceResultRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        ProcessInstanceRelated instance;
        long bits = 0L;
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
        }
        if (object instanceof ProcessInstanceResultRecordValue) {
            String bpmnProcessIdValue;
            instance = (ProcessInstanceResultRecordValue)object;
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
            if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                this.bpmnProcessId(bpmnProcessIdValue);
            }
            this.version(instance.getVersion());
            this.processDefinitionKey(instance.getProcessDefinitionKey());
        }
        if (object instanceof RecordValueWithVariables) {
            instance = (RecordValueWithVariables)object;
            this.putAllVariables(instance.getVariables());
        }
    }

    public final ProcessInstanceResultRecordValueBuilder putVariables(String key, Object value) {
        this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
        return this;
    }

    public final ProcessInstanceResultRecordValueBuilder putVariables(Map.Entry<String, ? extends Object> entry) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        return this;
    }

    @JsonProperty(value="variables")
    public final ProcessInstanceResultRecordValueBuilder variables(Map<String, ? extends Object> entries) {
        this.variables.clear();
        return this.putAllVariables(entries);
    }

    public final ProcessInstanceResultRecordValueBuilder putAllVariables(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        }
        return this;
    }

    @JsonProperty(value="bpmnProcessId")
    public final ProcessInstanceResultRecordValueBuilder bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @JsonProperty(value="version")
    public final ProcessInstanceResultRecordValueBuilder version(int version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="processDefinitionKey")
    public final ProcessInstanceResultRecordValueBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final ProcessInstanceResultRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public ProcessInstanceResultRecordValueBuilder clear() {
        this.variables.clear();
        this.bpmnProcessId = null;
        this.version = 0;
        this.processDefinitionKey = 0L;
        this.processInstanceKey = 0L;
        return this;
    }

    public AbstractProcessInstanceResultRecordValue build() {
        return new ImmutableProcessInstanceResultRecordValue(this);
    }

    @Generated(from="AbstractProcessInstanceResultRecordValue", generator="Immutables")
    static final class ImmutableProcessInstanceResultRecordValue
    extends AbstractProcessInstanceResultRecordValue {
        private final Map<String, Object> variables;
        private final String bpmnProcessId;
        private final int version;
        private final long processDefinitionKey;
        private final long processInstanceKey;
        private transient int hashCode;

        private ImmutableProcessInstanceResultRecordValue(ProcessInstanceResultRecordValueBuilder builder) {
            this.variables = Map.copyOf(builder.variables);
            this.bpmnProcessId = builder.bpmnProcessId;
            this.version = builder.version;
            this.processDefinitionKey = builder.processDefinitionKey;
            this.processInstanceKey = builder.processInstanceKey;
        }

        @JsonProperty(value="variables")
        public Map<String, Object> getVariables() {
            return this.variables;
        }

        @JsonProperty(value="bpmnProcessId")
        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        @JsonProperty(value="version")
        public int getVersion() {
            return this.version;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableProcessInstanceResultRecordValue && this.equalTo(0, (ImmutableProcessInstanceResultRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableProcessInstanceResultRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.variables.equals(another.variables) && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
            h += (h << 5) + this.version;
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            return h;
        }

        public String toString() {
            return "ProcessInstanceResultRecordValue{variables=" + this.variables + ", bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableProcessInstanceResultRecordValue fromJson(Json json) {
            ProcessInstanceResultRecordValueBuilder builder = new ProcessInstanceResultRecordValueBuilder();
            if (json.variables != null) {
                builder.putAllVariables(json.variables);
            }
            if (json.bpmnProcessId != null) {
                builder.bpmnProcessId(json.bpmnProcessId);
            }
            if (json.versionIsSet) {
                builder.version(json.version);
            }
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            return (ImmutableProcessInstanceResultRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractProcessInstanceResultRecordValue", generator="Immutables")
        static final class Json
        extends AbstractProcessInstanceResultRecordValue {
            Map<String, Object> variables = Map.of();
            String bpmnProcessId;
            int version;
            boolean versionIsSet;
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;
            long processInstanceKey;
            boolean processInstanceKeyIsSet;

            Json() {
            }

            @JsonProperty(value="variables")
            public void setVariables(Map<String, Object> variables) {
                this.variables = variables;
            }

            @JsonProperty(value="bpmnProcessId")
            public void setBpmnProcessId(String bpmnProcessId) {
                this.bpmnProcessId = bpmnProcessId;
            }

            @JsonProperty(value="version")
            public void setVersion(int version) {
                this.version = version;
                this.versionIsSet = true;
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            public Map<String, Object> getVariables() {
                throw new UnsupportedOperationException();
            }

            public String getBpmnProcessId() {
                throw new UnsupportedOperationException();
            }

            public int getVersion() {
                throw new UnsupportedOperationException();
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

