/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessMessageSubscriptionRecordValue", generator="Immutables")
public final class ProcessMessageSubscriptionRecordValueBuilder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private long elementInstanceKey;
    private String bpmnProcessId;
    private long messageKey;
    private String messageName;
    private String correlationKey;
    private String elementId;
    private boolean interrupting;

    public final ProcessMessageSubscriptionRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessMessageSubscriptionRecordValueBuilder from(ProcessMessageSubscriptionRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessMessageSubscriptionRecordValueBuilder from(RecordValueWithVariables instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final ProcessMessageSubscriptionRecordValueBuilder from(AbstractProcessMessageSubscriptionRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        ProcessInstanceRelated instance;
        long bits = 0L;
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
        }
        if (object instanceof ProcessMessageSubscriptionRecordValue) {
            String correlationKeyValue;
            String elementIdValue;
            instance = (ProcessMessageSubscriptionRecordValue)object;
            String messageNameValue = instance.getMessageName();
            if (messageNameValue != null) {
                this.messageName(messageNameValue);
            }
            if ((elementIdValue = instance.getElementId()) != null) {
                this.elementId(elementIdValue);
            }
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
            this.messageKey(instance.getMessageKey());
            this.elementInstanceKey(instance.getElementInstanceKey());
            this.interrupting(instance.isInterrupting());
            String bpmnProcessIdValue = instance.getBpmnProcessId();
            if (bpmnProcessIdValue != null) {
                this.bpmnProcessId(bpmnProcessIdValue);
            }
            if ((correlationKeyValue = instance.getCorrelationKey()) != null) {
                this.correlationKey(correlationKeyValue);
            }
        }
        if (object instanceof RecordValueWithVariables) {
            instance = (RecordValueWithVariables)object;
            this.putAllVariables(instance.getVariables());
        }
    }

    public final ProcessMessageSubscriptionRecordValueBuilder putVariables(String key, Object value) {
        this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
        return this;
    }

    public final ProcessMessageSubscriptionRecordValueBuilder putVariables(Map.Entry<String, ? extends Object> entry) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        return this;
    }

    @JsonProperty(value="variables")
    public final ProcessMessageSubscriptionRecordValueBuilder variables(Map<String, ? extends Object> entries) {
        this.variables.clear();
        return this.putAllVariables(entries);
    }

    public final ProcessMessageSubscriptionRecordValueBuilder putAllVariables(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
        }
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final ProcessMessageSubscriptionRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @JsonProperty(value="elementInstanceKey")
    public final ProcessMessageSubscriptionRecordValueBuilder elementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @JsonProperty(value="bpmnProcessId")
    public final ProcessMessageSubscriptionRecordValueBuilder bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @JsonProperty(value="messageKey")
    public final ProcessMessageSubscriptionRecordValueBuilder messageKey(long messageKey) {
        this.messageKey = messageKey;
        return this;
    }

    @JsonProperty(value="messageName")
    public final ProcessMessageSubscriptionRecordValueBuilder messageName(String messageName) {
        this.messageName = messageName;
        return this;
    }

    @JsonProperty(value="correlationKey")
    public final ProcessMessageSubscriptionRecordValueBuilder correlationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    @JsonProperty(value="elementId")
    public final ProcessMessageSubscriptionRecordValueBuilder elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @JsonProperty(value="interrupting")
    public final ProcessMessageSubscriptionRecordValueBuilder interrupting(boolean interrupting) {
        this.interrupting = interrupting;
        return this;
    }

    public ProcessMessageSubscriptionRecordValueBuilder clear() {
        this.variables.clear();
        this.processInstanceKey = 0L;
        this.elementInstanceKey = 0L;
        this.bpmnProcessId = null;
        this.messageKey = 0L;
        this.messageName = null;
        this.correlationKey = null;
        this.elementId = null;
        this.interrupting = false;
        return this;
    }

    public AbstractProcessMessageSubscriptionRecordValue build() {
        return new ImmutableProcessMessageSubscriptionRecordValue(this);
    }

    @Generated(from="AbstractProcessMessageSubscriptionRecordValue", generator="Immutables")
    static final class ImmutableProcessMessageSubscriptionRecordValue
    extends AbstractProcessMessageSubscriptionRecordValue {
        private final Map<String, Object> variables;
        private final long processInstanceKey;
        private final long elementInstanceKey;
        private final String bpmnProcessId;
        private final long messageKey;
        private final String messageName;
        private final String correlationKey;
        private final String elementId;
        private final boolean interrupting;
        private transient int hashCode;

        private ImmutableProcessMessageSubscriptionRecordValue(ProcessMessageSubscriptionRecordValueBuilder builder) {
            this.variables = Map.copyOf(builder.variables);
            this.processInstanceKey = builder.processInstanceKey;
            this.elementInstanceKey = builder.elementInstanceKey;
            this.bpmnProcessId = builder.bpmnProcessId;
            this.messageKey = builder.messageKey;
            this.messageName = builder.messageName;
            this.correlationKey = builder.correlationKey;
            this.elementId = builder.elementId;
            this.interrupting = builder.interrupting;
        }

        @JsonProperty(value="variables")
        public Map<String, Object> getVariables() {
            return this.variables;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @JsonProperty(value="elementInstanceKey")
        public long getElementInstanceKey() {
            return this.elementInstanceKey;
        }

        @JsonProperty(value="bpmnProcessId")
        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        @JsonProperty(value="messageKey")
        public long getMessageKey() {
            return this.messageKey;
        }

        @JsonProperty(value="messageName")
        public String getMessageName() {
            return this.messageName;
        }

        @JsonProperty(value="correlationKey")
        public String getCorrelationKey() {
            return this.correlationKey;
        }

        @JsonProperty(value="elementId")
        public String getElementId() {
            return this.elementId;
        }

        @JsonProperty(value="interrupting")
        public boolean isInterrupting() {
            return this.interrupting;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableProcessMessageSubscriptionRecordValue && this.equalTo(0, (ImmutableProcessMessageSubscriptionRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableProcessMessageSubscriptionRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && this.elementInstanceKey == another.elementInstanceKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.messageKey == another.messageKey && Objects.equals(this.messageName, another.messageName) && Objects.equals(this.correlationKey, another.correlationKey) && Objects.equals(this.elementId, another.elementId) && this.interrupting == another.interrupting;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            h += (h << 5) + Long.hashCode(this.elementInstanceKey);
            h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
            h += (h << 5) + Long.hashCode(this.messageKey);
            h += (h << 5) + Objects.hashCode(this.messageName);
            h += (h << 5) + Objects.hashCode(this.correlationKey);
            h += (h << 5) + Objects.hashCode(this.elementId);
            h += (h << 5) + Boolean.hashCode(this.interrupting);
            return h;
        }

        public String toString() {
            return "ProcessMessageSubscriptionRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", elementInstanceKey=" + this.elementInstanceKey + ", bpmnProcessId=" + this.bpmnProcessId + ", messageKey=" + this.messageKey + ", messageName=" + this.messageName + ", correlationKey=" + this.correlationKey + ", elementId=" + this.elementId + ", interrupting=" + this.interrupting + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableProcessMessageSubscriptionRecordValue fromJson(Json json) {
            ProcessMessageSubscriptionRecordValueBuilder builder = new ProcessMessageSubscriptionRecordValueBuilder();
            if (json.variables != null) {
                builder.putAllVariables(json.variables);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            if (json.elementInstanceKeyIsSet) {
                builder.elementInstanceKey(json.elementInstanceKey);
            }
            if (json.bpmnProcessId != null) {
                builder.bpmnProcessId(json.bpmnProcessId);
            }
            if (json.messageKeyIsSet) {
                builder.messageKey(json.messageKey);
            }
            if (json.messageName != null) {
                builder.messageName(json.messageName);
            }
            if (json.correlationKey != null) {
                builder.correlationKey(json.correlationKey);
            }
            if (json.elementId != null) {
                builder.elementId(json.elementId);
            }
            if (json.interruptingIsSet) {
                builder.interrupting(json.interrupting);
            }
            return (ImmutableProcessMessageSubscriptionRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractProcessMessageSubscriptionRecordValue", generator="Immutables")
        static final class Json
        extends AbstractProcessMessageSubscriptionRecordValue {
            Map<String, Object> variables = Map.of();
            long processInstanceKey;
            boolean processInstanceKeyIsSet;
            long elementInstanceKey;
            boolean elementInstanceKeyIsSet;
            String bpmnProcessId;
            long messageKey;
            boolean messageKeyIsSet;
            String messageName;
            String correlationKey;
            String elementId;
            boolean interrupting;
            boolean interruptingIsSet;

            Json() {
            }

            @JsonProperty(value="variables")
            public void setVariables(Map<String, Object> variables) {
                this.variables = variables;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            @JsonProperty(value="elementInstanceKey")
            public void setElementInstanceKey(long elementInstanceKey) {
                this.elementInstanceKey = elementInstanceKey;
                this.elementInstanceKeyIsSet = true;
            }

            @JsonProperty(value="bpmnProcessId")
            public void setBpmnProcessId(String bpmnProcessId) {
                this.bpmnProcessId = bpmnProcessId;
            }

            @JsonProperty(value="messageKey")
            public void setMessageKey(long messageKey) {
                this.messageKey = messageKey;
                this.messageKeyIsSet = true;
            }

            @JsonProperty(value="messageName")
            public void setMessageName(String messageName) {
                this.messageName = messageName;
            }

            @JsonProperty(value="correlationKey")
            public void setCorrelationKey(String correlationKey) {
                this.correlationKey = correlationKey;
            }

            @JsonProperty(value="elementId")
            public void setElementId(String elementId) {
                this.elementId = elementId;
            }

            @JsonProperty(value="interrupting")
            public void setInterrupting(boolean interrupting) {
                this.interrupting = interrupting;
                this.interruptingIsSet = true;
            }

            public Map<String, Object> getVariables() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public long getElementInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public String getBpmnProcessId() {
                throw new UnsupportedOperationException();
            }

            public long getMessageKey() {
                throw new UnsupportedOperationException();
            }

            public String getMessageName() {
                throw new UnsupportedOperationException();
            }

            public String getCorrelationKey() {
                throw new UnsupportedOperationException();
            }

            public String getElementId() {
                throw new UnsupportedOperationException();
            }

            public boolean isInterrupting() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

