/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractTimerRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractTimerRecordValue", generator="Immutables")
public final class TimerRecordValueBuilder {
    private long processDefinitionKey;
    private long elementInstanceKey;
    private long processInstanceKey;
    private long dueDate;
    private String targetElementId;
    private int repetitions;

    public final TimerRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final TimerRecordValueBuilder from(TimerRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final TimerRecordValueBuilder from(AbstractTimerRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        ProcessInstanceRelated instance;
        long bits = 0L;
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
        }
        if (object instanceof TimerRecordValue) {
            instance = (TimerRecordValue)object;
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
            this.elementInstanceKey(instance.getElementInstanceKey());
            String targetElementIdValue = instance.getTargetElementId();
            if (targetElementIdValue != null) {
                this.targetElementId(targetElementIdValue);
            }
            this.repetitions(instance.getRepetitions());
            this.dueDate(instance.getDueDate());
            this.processDefinitionKey(instance.getProcessDefinitionKey());
        }
    }

    @JsonProperty(value="processDefinitionKey")
    public final TimerRecordValueBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @JsonProperty(value="elementInstanceKey")
    public final TimerRecordValueBuilder elementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final TimerRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @JsonProperty(value="dueDate")
    public final TimerRecordValueBuilder dueDate(long dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @JsonProperty(value="targetElementId")
    public final TimerRecordValueBuilder targetElementId(String targetElementId) {
        this.targetElementId = targetElementId;
        return this;
    }

    @JsonProperty(value="repetitions")
    public final TimerRecordValueBuilder repetitions(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public TimerRecordValueBuilder clear() {
        this.processDefinitionKey = 0L;
        this.elementInstanceKey = 0L;
        this.processInstanceKey = 0L;
        this.dueDate = 0L;
        this.targetElementId = null;
        this.repetitions = 0;
        return this;
    }

    public AbstractTimerRecordValue build() {
        return new ImmutableTimerRecordValue(this);
    }

    @Generated(from="AbstractTimerRecordValue", generator="Immutables")
    static final class ImmutableTimerRecordValue
    extends AbstractTimerRecordValue {
        private final long processDefinitionKey;
        private final long elementInstanceKey;
        private final long processInstanceKey;
        private final long dueDate;
        private final String targetElementId;
        private final int repetitions;
        private transient int hashCode;

        private ImmutableTimerRecordValue(TimerRecordValueBuilder builder) {
            this.processDefinitionKey = builder.processDefinitionKey;
            this.elementInstanceKey = builder.elementInstanceKey;
            this.processInstanceKey = builder.processInstanceKey;
            this.dueDate = builder.dueDate;
            this.targetElementId = builder.targetElementId;
            this.repetitions = builder.repetitions;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        @JsonProperty(value="elementInstanceKey")
        public long getElementInstanceKey() {
            return this.elementInstanceKey;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @JsonProperty(value="dueDate")
        public long getDueDate() {
            return this.dueDate;
        }

        @JsonProperty(value="targetElementId")
        public String getTargetElementId() {
            return this.targetElementId;
        }

        @JsonProperty(value="repetitions")
        public int getRepetitions() {
            return this.repetitions;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableTimerRecordValue && this.equalTo(0, (ImmutableTimerRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableTimerRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return this.processDefinitionKey == another.processDefinitionKey && this.elementInstanceKey == another.elementInstanceKey && this.processInstanceKey == another.processInstanceKey && this.dueDate == another.dueDate && Objects.equals(this.targetElementId, another.targetElementId) && this.repetitions == another.repetitions;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            h += (h << 5) + Long.hashCode(this.elementInstanceKey);
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            h += (h << 5) + Long.hashCode(this.dueDate);
            h += (h << 5) + Objects.hashCode(this.targetElementId);
            h += (h << 5) + this.repetitions;
            return h;
        }

        public String toString() {
            return "TimerRecordValue{processDefinitionKey=" + this.processDefinitionKey + ", elementInstanceKey=" + this.elementInstanceKey + ", processInstanceKey=" + this.processInstanceKey + ", dueDate=" + this.dueDate + ", targetElementId=" + this.targetElementId + ", repetitions=" + this.repetitions + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableTimerRecordValue fromJson(Json json) {
            TimerRecordValueBuilder builder = new TimerRecordValueBuilder();
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            if (json.elementInstanceKeyIsSet) {
                builder.elementInstanceKey(json.elementInstanceKey);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            if (json.dueDateIsSet) {
                builder.dueDate(json.dueDate);
            }
            if (json.targetElementId != null) {
                builder.targetElementId(json.targetElementId);
            }
            if (json.repetitionsIsSet) {
                builder.repetitions(json.repetitions);
            }
            return (ImmutableTimerRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractTimerRecordValue", generator="Immutables")
        static final class Json
        extends AbstractTimerRecordValue {
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;
            long elementInstanceKey;
            boolean elementInstanceKeyIsSet;
            long processInstanceKey;
            boolean processInstanceKeyIsSet;
            long dueDate;
            boolean dueDateIsSet;
            String targetElementId;
            int repetitions;
            boolean repetitionsIsSet;

            Json() {
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            @JsonProperty(value="elementInstanceKey")
            public void setElementInstanceKey(long elementInstanceKey) {
                this.elementInstanceKey = elementInstanceKey;
                this.elementInstanceKeyIsSet = true;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            @JsonProperty(value="dueDate")
            public void setDueDate(long dueDate) {
                this.dueDate = dueDate;
                this.dueDateIsSet = true;
            }

            @JsonProperty(value="targetElementId")
            public void setTargetElementId(String targetElementId) {
                this.targetElementId = targetElementId;
            }

            @JsonProperty(value="repetitions")
            public void setRepetitions(int repetitions) {
                this.repetitions = repetitions;
                this.repetitionsIsSet = true;
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }

            public long getElementInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public long getDueDate() {
                throw new UnsupportedOperationException();
            }

            public String getTargetElementId() {
                throw new UnsupportedOperationException();
            }

            public int getRepetitions() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

