/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.camunda.zeebe.protocol.jackson.record.ValueTypes;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;

final class ValueTypeIdResolver
extends TypeIdResolverBase {
    ValueTypeIdResolver() {
    }

    public String idFromValue(Object value) {
        return ((ValueType)value).name();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        ValueType valueType = ValueType.valueOf((String)id);
        TypeFactory typeFactory = context.getTypeFactory();
        return typeFactory.constructType(this.mapValueTypeToRecordValue(valueType));
    }

    private Class<? extends RecordValue> mapValueTypeToRecordValue(ValueType valueType) {
        return ValueTypes.getTypeInfo(valueType).getValueClass();
    }
}

