/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import io.camunda.zeebe.protocol.jackson.record.DeploymentDistributionRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.DeploymentRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.ErrorRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.IncidentRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.JobBatchRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.JobRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.MessageRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.MessageStartEventSubscriptionRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.MessageSubscriptionRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.ProcessBuilder;
import io.camunda.zeebe.protocol.jackson.record.ProcessEventRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.ProcessInstanceCreationRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.ProcessInstanceRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.ProcessInstanceResultRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.ProcessMessageSubscriptionRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.TimerRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.ValueTypeInfo;
import io.camunda.zeebe.protocol.jackson.record.VariableDocumentRecordValueBuilder;
import io.camunda.zeebe.protocol.jackson.record.VariableRecordValueBuilder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceResultIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import java.util.EnumMap;
import java.util.Map;

final class ValueTypes {
    private static final Map<ValueType, ValueTypeInfo<?>> TYPES;

    private ValueTypes() {
    }

    static ValueTypeInfo<?> getTypeInfo(ValueType valueType) {
        ValueTypeInfo<?> typeInfo = TYPES.get(valueType);
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Expected value type to be one of %s, but was %s", TYPES.keySet(), valueType));
        }
        return typeInfo;
    }

    static ValueTypeInfo<?> getTypeInfoOrNull(ValueType valueType) {
        return TYPES.get(valueType);
    }

    static {
        EnumMap mapping = new EnumMap(ValueType.class);
        mapping.put(ValueType.DEPLOYMENT, new ValueTypeInfo<DeploymentRecordValueBuilder.ImmutableDeploymentRecordValue>(DeploymentRecordValueBuilder.ImmutableDeploymentRecordValue.class, DeploymentIntent.class));
        mapping.put(ValueType.DEPLOYMENT_DISTRIBUTION, new ValueTypeInfo<DeploymentDistributionRecordValueBuilder.ImmutableDeploymentDistributionRecordValue>(DeploymentDistributionRecordValueBuilder.ImmutableDeploymentDistributionRecordValue.class, DeploymentDistributionIntent.class));
        mapping.put(ValueType.ERROR, new ValueTypeInfo<ErrorRecordValueBuilder.ImmutableErrorRecordValue>(ErrorRecordValueBuilder.ImmutableErrorRecordValue.class, ErrorIntent.class));
        mapping.put(ValueType.INCIDENT, new ValueTypeInfo<IncidentRecordValueBuilder.ImmutableIncidentRecordValue>(IncidentRecordValueBuilder.ImmutableIncidentRecordValue.class, IncidentIntent.class));
        mapping.put(ValueType.JOB, new ValueTypeInfo<JobRecordValueBuilder.ImmutableJobRecordValue>(JobRecordValueBuilder.ImmutableJobRecordValue.class, JobIntent.class));
        mapping.put(ValueType.JOB_BATCH, new ValueTypeInfo<JobBatchRecordValueBuilder.ImmutableJobBatchRecordValue>(JobBatchRecordValueBuilder.ImmutableJobBatchRecordValue.class, JobBatchIntent.class));
        mapping.put(ValueType.MESSAGE, new ValueTypeInfo<MessageRecordValueBuilder.ImmutableMessageRecordValue>(MessageRecordValueBuilder.ImmutableMessageRecordValue.class, MessageIntent.class));
        mapping.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, new ValueTypeInfo<MessageStartEventSubscriptionRecordValueBuilder.ImmutableMessageStartEventSubscriptionRecordValue>(MessageStartEventSubscriptionRecordValueBuilder.ImmutableMessageStartEventSubscriptionRecordValue.class, MessageStartEventSubscriptionIntent.class));
        mapping.put(ValueType.MESSAGE_SUBSCRIPTION, new ValueTypeInfo<MessageSubscriptionRecordValueBuilder.ImmutableMessageSubscriptionRecordValue>(MessageSubscriptionRecordValueBuilder.ImmutableMessageSubscriptionRecordValue.class, MessageSubscriptionIntent.class));
        mapping.put(ValueType.PROCESS, new ValueTypeInfo<ProcessBuilder.ImmutableProcess>(ProcessBuilder.ImmutableProcess.class, ProcessIntent.class));
        mapping.put(ValueType.PROCESS_EVENT, new ValueTypeInfo<ProcessEventRecordValueBuilder.ImmutableProcessEventRecordValue>(ProcessEventRecordValueBuilder.ImmutableProcessEventRecordValue.class, ProcessEventIntent.class));
        mapping.put(ValueType.PROCESS_INSTANCE, new ValueTypeInfo<ProcessInstanceRecordValueBuilder.ImmutableProcessInstanceRecordValue>(ProcessInstanceRecordValueBuilder.ImmutableProcessInstanceRecordValue.class, ProcessInstanceIntent.class));
        mapping.put(ValueType.PROCESS_INSTANCE_CREATION, new ValueTypeInfo<ProcessInstanceCreationRecordValueBuilder.ImmutableProcessInstanceCreationRecordValue>(ProcessInstanceCreationRecordValueBuilder.ImmutableProcessInstanceCreationRecordValue.class, ProcessInstanceCreationIntent.class));
        mapping.put(ValueType.PROCESS_INSTANCE_RESULT, new ValueTypeInfo<ProcessInstanceResultRecordValueBuilder.ImmutableProcessInstanceResultRecordValue>(ProcessInstanceResultRecordValueBuilder.ImmutableProcessInstanceResultRecordValue.class, ProcessInstanceResultIntent.class));
        mapping.put(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, new ValueTypeInfo<ProcessMessageSubscriptionRecordValueBuilder.ImmutableProcessMessageSubscriptionRecordValue>(ProcessMessageSubscriptionRecordValueBuilder.ImmutableProcessMessageSubscriptionRecordValue.class, ProcessMessageSubscriptionIntent.class));
        mapping.put(ValueType.TIMER, new ValueTypeInfo<TimerRecordValueBuilder.ImmutableTimerRecordValue>(TimerRecordValueBuilder.ImmutableTimerRecordValue.class, TimerIntent.class));
        mapping.put(ValueType.VARIABLE, new ValueTypeInfo<VariableRecordValueBuilder.ImmutableVariableRecordValue>(VariableRecordValueBuilder.ImmutableVariableRecordValue.class, VariableIntent.class));
        mapping.put(ValueType.VARIABLE_DOCUMENT, new ValueTypeInfo<VariableDocumentRecordValueBuilder.ImmutableVariableDocumentRecordValue>(VariableDocumentRecordValueBuilder.ImmutableVariableDocumentRecordValue.class, VariableDocumentIntent.class));
        TYPES = mapping;
    }
}

