/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.jackson.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.jackson.record.AbstractVariableRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractVariableRecordValue", generator="Immutables")
public final class VariableRecordValueBuilder {
    private String name;
    private String value;
    private long scopeKey;
    private long processInstanceKey;
    private long processDefinitionKey;

    public final VariableRecordValueBuilder from(ProcessInstanceRelated instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final VariableRecordValueBuilder from(VariableRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    public final VariableRecordValueBuilder from(AbstractVariableRecordValue instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return this;
    }

    private void from(Object object) {
        ProcessInstanceRelated instance;
        long bits = 0L;
        if (object instanceof ProcessInstanceRelated) {
            instance = (ProcessInstanceRelated)object;
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
        }
        if (object instanceof VariableRecordValue) {
            String valueValue;
            instance = (VariableRecordValue)object;
            String nameValue = instance.getName();
            if (nameValue != null) {
                this.name(nameValue);
            }
            this.scopeKey(instance.getScopeKey());
            if ((bits & 1L) == 0L) {
                this.processInstanceKey(instance.getProcessInstanceKey());
                bits |= 1L;
            }
            if ((valueValue = instance.getValue()) != null) {
                this.value(valueValue);
            }
            this.processDefinitionKey(instance.getProcessDefinitionKey());
        }
    }

    @JsonProperty(value="name")
    public final VariableRecordValueBuilder name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="value")
    public final VariableRecordValueBuilder value(String value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="scopeKey")
    public final VariableRecordValueBuilder scopeKey(long scopeKey) {
        this.scopeKey = scopeKey;
        return this;
    }

    @JsonProperty(value="processInstanceKey")
    public final VariableRecordValueBuilder processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @JsonProperty(value="processDefinitionKey")
    public final VariableRecordValueBuilder processDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public VariableRecordValueBuilder clear() {
        this.name = null;
        this.value = null;
        this.scopeKey = 0L;
        this.processInstanceKey = 0L;
        this.processDefinitionKey = 0L;
        return this;
    }

    public AbstractVariableRecordValue build() {
        return new ImmutableVariableRecordValue(this);
    }

    @Generated(from="AbstractVariableRecordValue", generator="Immutables")
    static final class ImmutableVariableRecordValue
    extends AbstractVariableRecordValue {
        private final String name;
        private final String value;
        private final long scopeKey;
        private final long processInstanceKey;
        private final long processDefinitionKey;
        private transient int hashCode;

        private ImmutableVariableRecordValue(VariableRecordValueBuilder builder) {
            this.name = builder.name;
            this.value = builder.value;
            this.scopeKey = builder.scopeKey;
            this.processInstanceKey = builder.processInstanceKey;
            this.processDefinitionKey = builder.processDefinitionKey;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }

        @JsonProperty(value="scopeKey")
        public long getScopeKey() {
            return this.scopeKey;
        }

        @JsonProperty(value="processInstanceKey")
        public long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @JsonProperty(value="processDefinitionKey")
        public long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableVariableRecordValue && this.equalTo(0, (ImmutableVariableRecordValue)another);
        }

        private boolean equalTo(int synthetic, ImmutableVariableRecordValue another) {
            if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
                return false;
            }
            return Objects.equals(this.name, another.name) && Objects.equals(this.value, another.value) && this.scopeKey == another.scopeKey && this.processInstanceKey == another.processInstanceKey && this.processDefinitionKey == another.processDefinitionKey;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = this.computeHashCode();
            }
            return h;
        }

        private int computeHashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.value);
            h += (h << 5) + Long.hashCode(this.scopeKey);
            h += (h << 5) + Long.hashCode(this.processInstanceKey);
            h += (h << 5) + Long.hashCode(this.processDefinitionKey);
            return h;
        }

        public String toString() {
            return "VariableRecordValue{name=" + this.name + ", value=" + this.value + ", scopeKey=" + this.scopeKey + ", processInstanceKey=" + this.processInstanceKey + ", processDefinitionKey=" + this.processDefinitionKey + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutableVariableRecordValue fromJson(Json json) {
            VariableRecordValueBuilder builder = new VariableRecordValueBuilder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.value != null) {
                builder.value(json.value);
            }
            if (json.scopeKeyIsSet) {
                builder.scopeKey(json.scopeKey);
            }
            if (json.processInstanceKeyIsSet) {
                builder.processInstanceKey(json.processInstanceKey);
            }
            if (json.processDefinitionKeyIsSet) {
                builder.processDefinitionKey(json.processDefinitionKey);
            }
            return (ImmutableVariableRecordValue)builder.build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="AbstractVariableRecordValue", generator="Immutables")
        static final class Json
        extends AbstractVariableRecordValue {
            String name;
            String value;
            long scopeKey;
            boolean scopeKeyIsSet;
            long processInstanceKey;
            boolean processInstanceKeyIsSet;
            long processDefinitionKey;
            boolean processDefinitionKeyIsSet;

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="value")
            public void setValue(String value) {
                this.value = value;
            }

            @JsonProperty(value="scopeKey")
            public void setScopeKey(long scopeKey) {
                this.scopeKey = scopeKey;
                this.scopeKeyIsSet = true;
            }

            @JsonProperty(value="processInstanceKey")
            public void setProcessInstanceKey(long processInstanceKey) {
                this.processInstanceKey = processInstanceKey;
                this.processInstanceKeyIsSet = true;
            }

            @JsonProperty(value="processDefinitionKey")
            public void setProcessDefinitionKey(long processDefinitionKey) {
                this.processDefinitionKey = processDefinitionKey;
                this.processDefinitionKeyIsSet = true;
            }

            public String getName() {
                throw new UnsupportedOperationException();
            }

            public String getValue() {
                throw new UnsupportedOperationException();
            }

            public long getScopeKey() {
                throw new UnsupportedOperationException();
            }

            public long getProcessInstanceKey() {
                throw new UnsupportedOperationException();
            }

            public long getProcessDefinitionKey() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

