package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErrorRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErrorRecordValue.builder()}.
 */
@Generated(from = "ErrorRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@ImmutableProtocol.Type(builder=ImmutableErrorRecordValue.Builder.class)
public final class ImmutableErrorRecordValue
    implements ErrorRecordValue {
  private final String exceptionMessage;
  private final String stacktrace;
  private final long errorEventPosition;
  private final long processInstanceKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableErrorRecordValue(
      String exceptionMessage,
      String stacktrace,
      long errorEventPosition,
      long processInstanceKey) {
    this.exceptionMessage = exceptionMessage;
    this.stacktrace = stacktrace;
    this.errorEventPosition = errorEventPosition;
    this.processInstanceKey = processInstanceKey;
  }

  /**
   * @return the exception message, which causes this error record.
   */
  @Override
  public String getExceptionMessage() {
    return exceptionMessage;
  }

  /**
   * @return the stacktrace, which belongs to the exception
   */
  @Override
  public String getStacktrace() {
    return stacktrace;
  }

  /**
   * @return the position of the event, which causes this error
   */
  @Override
  public long getErrorEventPosition() {
    return errorEventPosition;
  }

  /**
   * @return the process instance key, which is related to the failed event. If the event is not
   *     process instance related, then this will return -1
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorRecordValue#getExceptionMessage() exceptionMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exceptionMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorRecordValue withExceptionMessage(String value) {
    if (Objects.equals(this.exceptionMessage, value)) return this;
    return new ImmutableErrorRecordValue(value, this.stacktrace, this.errorEventPosition, this.processInstanceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorRecordValue#getStacktrace() stacktrace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stacktrace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorRecordValue withStacktrace(String value) {
    if (Objects.equals(this.stacktrace, value)) return this;
    return new ImmutableErrorRecordValue(this.exceptionMessage, value, this.errorEventPosition, this.processInstanceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorRecordValue#getErrorEventPosition() errorEventPosition} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorEventPosition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorRecordValue withErrorEventPosition(long value) {
    if (this.errorEventPosition == value) return this;
    return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, value, this.processInstanceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, this.errorEventPosition, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErrorRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErrorRecordValue
        && equalTo(0, (ImmutableErrorRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableErrorRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(exceptionMessage, another.exceptionMessage)
        && Objects.equals(stacktrace, another.stacktrace)
        && errorEventPosition == another.errorEventPosition
        && processInstanceKey == another.processInstanceKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code exceptionMessage}, {@code stacktrace}, {@code errorEventPosition}, {@code processInstanceKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(exceptionMessage);
    h += (h << 5) + Objects.hashCode(stacktrace);
    h += (h << 5) + Long.hashCode(errorEventPosition);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    return h;
  }

  /**
   * Prints the immutable value {@code ErrorRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ErrorRecordValue{"
        + "exceptionMessage=" + exceptionMessage
        + ", stacktrace=" + stacktrace
        + ", errorEventPosition=" + errorEventPosition
        + ", processInstanceKey=" + processInstanceKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ErrorRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ErrorRecordValue instance
   */
  public static ImmutableErrorRecordValue copyOf(ErrorRecordValue instance) {
    if (instance instanceof ImmutableErrorRecordValue) {
      return (ImmutableErrorRecordValue) instance;
    }
    return ImmutableErrorRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErrorRecordValue ImmutableErrorRecordValue}.
   * <pre>
   * ImmutableErrorRecordValue.builder()
   *    .withExceptionMessage(String | null) // nullable {@link ErrorRecordValue#getExceptionMessage() exceptionMessage}
   *    .withStacktrace(String | null) // nullable {@link ErrorRecordValue#getStacktrace() stacktrace}
   *    .withErrorEventPosition(long) // optional {@link ErrorRecordValue#getErrorEventPosition() errorEventPosition}
   *    .withProcessInstanceKey(long) // optional {@link ErrorRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .build();
   * </pre>
   * @return A new ImmutableErrorRecordValue builder
   */
  public static ImmutableErrorRecordValue.Builder builder() {
    return new ImmutableErrorRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErrorRecordValue ImmutableErrorRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErrorRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String exceptionMessage;
    private @Nullable String stacktrace;
    private long errorEventPosition;
    private long processInstanceKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ErrorRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ErrorRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      String exceptionMessageValue = instance.getExceptionMessage();
      if (exceptionMessageValue != null) {
        withExceptionMessage(exceptionMessageValue);
      }
      String stacktraceValue = instance.getStacktrace();
      if (stacktraceValue != null) {
        withStacktrace(stacktraceValue);
      }
      withErrorEventPosition(instance.getErrorEventPosition());
      withProcessInstanceKey(instance.getProcessInstanceKey());
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorRecordValue#getExceptionMessage() exceptionMessage} attribute.
     * @param exceptionMessage The value for exceptionMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withExceptionMessage(String exceptionMessage) {
      this.exceptionMessage = exceptionMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorRecordValue#getStacktrace() stacktrace} attribute.
     * @param stacktrace The value for stacktrace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withStacktrace(String stacktrace) {
      this.stacktrace = stacktrace;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorRecordValue#getErrorEventPosition() errorEventPosition} attribute.
     * @param errorEventPosition The value for errorEventPosition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withErrorEventPosition(long errorEventPosition) {
      this.errorEventPosition = errorEventPosition;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.exceptionMessage = null;
      this.stacktrace = null;
      this.errorEventPosition = 0;
      this.processInstanceKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableErrorRecordValue ImmutableErrorRecordValue}.
     * @return An immutable instance of ErrorRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErrorRecordValue build() {
      return new ImmutableErrorRecordValue(exceptionMessage, stacktrace, errorEventPosition, processInstanceKey);
    }



  }



}
