package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DecisionRequirementsRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDecisionRequirementsRecordValue.builder()}.
 */
@Generated(from = "DecisionRequirementsRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@ImmutableProtocol.Type(builder=ImmutableDecisionRequirementsRecordValue.Builder.class)
public final class ImmutableDecisionRequirementsRecordValue
    implements DecisionRequirementsRecordValue {
  private final String decisionRequirementsId;
  private final String decisionRequirementsName;
  private final int decisionRequirementsVersion;
  private final long decisionRequirementsKey;
  private final String namespace;
  private final String resourceName;
  private final byte[] checksum;
  private final boolean duplicate;
  private final byte[] resource;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableDecisionRequirementsRecordValue(
      String decisionRequirementsId,
      String decisionRequirementsName,
      int decisionRequirementsVersion,
      long decisionRequirementsKey,
      String namespace,
      String resourceName,
      byte[] checksum,
      boolean duplicate,
      byte[] resource) {
    this.decisionRequirementsId = decisionRequirementsId;
    this.decisionRequirementsName = decisionRequirementsName;
    this.decisionRequirementsVersion = decisionRequirementsVersion;
    this.decisionRequirementsKey = decisionRequirementsKey;
    this.namespace = namespace;
    this.resourceName = resourceName;
    this.checksum = checksum;
    this.duplicate = duplicate;
    this.resource = resource;
  }

  /**
   * @return the ID of the DRG in the DMN
   */
  @Override
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  /**
   * @return the name of the DRG in the DMN
   */
  @Override
  public String getDecisionRequirementsName() {
    return decisionRequirementsName;
  }

  /**
   * @return the version of the deployed DRG
   */
  @Override
  public int getDecisionRequirementsVersion() {
    return decisionRequirementsVersion;
  }

  /**
   * @return the key of the deployed DRG
   */
  @Override
  public long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  /**
   * @return the namespace of the DRG in the DMN
   */
  @Override
  public String getNamespace() {
    return namespace;
  }

  /**
   * @return the name of the resource through which this DRG was deployed
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   * @return the checksum of the DMN resource (MD5)
   */
  @Override
  public byte[] getChecksum() {
    return checksum;
  }

  /**
   * @return {@code true} if the DRG is a duplicate (and has been deployed previously), otherwise
   *     {@code false}
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   * @return the binary DMN resource
   */
  @Override
  public byte[] getResource() {
    return resource;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withDecisionRequirementsId(String value) {
    if (Objects.equals(this.decisionRequirementsId, value)) return this;
    return new ImmutableDecisionRequirementsRecordValue(
        value,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsName() decisionRequirementsName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withDecisionRequirementsName(String value) {
    if (Objects.equals(this.decisionRequirementsName, value)) return this;
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        value,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsVersion() decisionRequirementsVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withDecisionRequirementsVersion(int value) {
    if (this.decisionRequirementsVersion == value) return this;
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        value,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withDecisionRequirementsKey(long value) {
    if (this.decisionRequirementsKey == value) return this;
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        value,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsRecordValue#getNamespace() namespace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for namespace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withNamespace(String value) {
    if (Objects.equals(this.namespace, value)) return this;
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        value,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsRecordValue#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        value,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DecisionRequirementsRecordValue#getChecksum() checksum}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for checksum
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withChecksum(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        newValue,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsRecordValue#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        value,
        this.resource);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DecisionRequirementsRecordValue#getResource() resource}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for resource
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDecisionRequirementsRecordValue withResource(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableDecisionRequirementsRecordValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDecisionRequirementsRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDecisionRequirementsRecordValue
        && equalTo(0, (ImmutableDecisionRequirementsRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDecisionRequirementsRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(decisionRequirementsId, another.decisionRequirementsId)
        && Objects.equals(decisionRequirementsName, another.decisionRequirementsName)
        && decisionRequirementsVersion == another.decisionRequirementsVersion
        && decisionRequirementsKey == another.decisionRequirementsKey
        && Objects.equals(namespace, another.namespace)
        && Objects.equals(resourceName, another.resourceName)
        && Arrays.equals(checksum, another.checksum)
        && duplicate == another.duplicate
        && Arrays.equals(resource, another.resource);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code decisionRequirementsId}, {@code decisionRequirementsName}, {@code decisionRequirementsVersion}, {@code decisionRequirementsKey}, {@code namespace}, {@code resourceName}, {@code checksum}, {@code duplicate}, {@code resource}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(decisionRequirementsId);
    h += (h << 5) + Objects.hashCode(decisionRequirementsName);
    h += (h << 5) + decisionRequirementsVersion;
    h += (h << 5) + Long.hashCode(decisionRequirementsKey);
    h += (h << 5) + Objects.hashCode(namespace);
    h += (h << 5) + Objects.hashCode(resourceName);
    h += (h << 5) + Arrays.hashCode(checksum);
    h += (h << 5) + Boolean.hashCode(duplicate);
    h += (h << 5) + Arrays.hashCode(resource);
    return h;
  }

  /**
   * Prints the immutable value {@code DecisionRequirementsRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DecisionRequirementsRecordValue{"
        + "decisionRequirementsId=" + decisionRequirementsId
        + ", decisionRequirementsName=" + decisionRequirementsName
        + ", decisionRequirementsVersion=" + decisionRequirementsVersion
        + ", decisionRequirementsKey=" + decisionRequirementsKey
        + ", namespace=" + namespace
        + ", resourceName=" + resourceName
        + ", checksum=" + Arrays.toString(checksum)
        + ", duplicate=" + duplicate
        + ", resource=" + Arrays.toString(resource)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DecisionRequirementsRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DecisionRequirementsRecordValue instance
   */
  public static ImmutableDecisionRequirementsRecordValue copyOf(DecisionRequirementsRecordValue instance) {
    if (instance instanceof ImmutableDecisionRequirementsRecordValue) {
      return (ImmutableDecisionRequirementsRecordValue) instance;
    }
    return ImmutableDecisionRequirementsRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDecisionRequirementsRecordValue ImmutableDecisionRequirementsRecordValue}.
   * <pre>
   * ImmutableDecisionRequirementsRecordValue.builder()
   *    .withDecisionRequirementsId(String | null) // nullable {@link DecisionRequirementsRecordValue#getDecisionRequirementsId() decisionRequirementsId}
   *    .withDecisionRequirementsName(String | null) // nullable {@link DecisionRequirementsRecordValue#getDecisionRequirementsName() decisionRequirementsName}
   *    .withDecisionRequirementsVersion(int) // optional {@link DecisionRequirementsRecordValue#getDecisionRequirementsVersion() decisionRequirementsVersion}
   *    .withDecisionRequirementsKey(long) // optional {@link DecisionRequirementsRecordValue#getDecisionRequirementsKey() decisionRequirementsKey}
   *    .withNamespace(String | null) // nullable {@link DecisionRequirementsRecordValue#getNamespace() namespace}
   *    .withResourceName(String | null) // nullable {@link DecisionRequirementsRecordValue#getResourceName() resourceName}
   *    .withChecksum(byte[] | null) // nullable {@link DecisionRequirementsRecordValue#getChecksum() checksum}
   *    .withDuplicate(boolean) // optional {@link DecisionRequirementsRecordValue#isDuplicate() duplicate}
   *    .withResource(byte[] | null) // nullable {@link DecisionRequirementsRecordValue#getResource() resource}
   *    .build();
   * </pre>
   * @return A new ImmutableDecisionRequirementsRecordValue builder
   */
  public static ImmutableDecisionRequirementsRecordValue.Builder builder() {
    return new ImmutableDecisionRequirementsRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDecisionRequirementsRecordValue ImmutableDecisionRequirementsRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DecisionRequirementsRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String decisionRequirementsId;
    private @Nullable String decisionRequirementsName;
    private int decisionRequirementsVersion;
    private long decisionRequirementsKey;
    private @Nullable String namespace;
    private @Nullable String resourceName;
    private @Nullable byte[] checksum;
    private boolean duplicate;
    private @Nullable byte[] resource;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DecisionRequirementsMetadataValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DecisionRequirementsRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof DecisionRequirementsMetadataValue) {
        DecisionRequirementsMetadataValue instance = (DecisionRequirementsMetadataValue) object;
        if ((bits & 0x1L) == 0) {
          withDecisionRequirementsKey(instance.getDecisionRequirementsKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String namespaceValue = instance.getNamespace();
          if (namespaceValue != null) {
            withNamespace(namespaceValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          byte[] checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            withChecksum(checksumValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          withDecisionRequirementsVersion(instance.getDecisionRequirementsVersion());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          String resourceNameValue = instance.getResourceName();
          if (resourceNameValue != null) {
            withResourceName(resourceNameValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          withDuplicate(instance.isDuplicate());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          String decisionRequirementsIdValue = instance.getDecisionRequirementsId();
          if (decisionRequirementsIdValue != null) {
            withDecisionRequirementsId(decisionRequirementsIdValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          String decisionRequirementsNameValue = instance.getDecisionRequirementsName();
          if (decisionRequirementsNameValue != null) {
            withDecisionRequirementsName(decisionRequirementsNameValue);
          }
          bits |= 0x80L;
        }
      }
      if (object instanceof DecisionRequirementsRecordValue) {
        DecisionRequirementsRecordValue instance = (DecisionRequirementsRecordValue) object;
        if ((bits & 0x1L) == 0) {
          withDecisionRequirementsKey(instance.getDecisionRequirementsKey());
          bits |= 0x1L;
        }
        byte[] resourceValue = instance.getResource();
        if (resourceValue != null) {
          withResource(resourceValue);
        }
        if ((bits & 0x2L) == 0) {
          String namespaceValue = instance.getNamespace();
          if (namespaceValue != null) {
            withNamespace(namespaceValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          byte[] checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            withChecksum(checksumValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          withDecisionRequirementsVersion(instance.getDecisionRequirementsVersion());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          String resourceNameValue = instance.getResourceName();
          if (resourceNameValue != null) {
            withResourceName(resourceNameValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          withDuplicate(instance.isDuplicate());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          String decisionRequirementsIdValue = instance.getDecisionRequirementsId();
          if (decisionRequirementsIdValue != null) {
            withDecisionRequirementsId(decisionRequirementsIdValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          String decisionRequirementsNameValue = instance.getDecisionRequirementsName();
          if (decisionRequirementsNameValue != null) {
            withDecisionRequirementsName(decisionRequirementsNameValue);
          }
          bits |= 0x80L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
     * @param decisionRequirementsId The value for decisionRequirementsId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsId(String decisionRequirementsId) {
      this.decisionRequirementsId = decisionRequirementsId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsName() decisionRequirementsName} attribute.
     * @param decisionRequirementsName The value for decisionRequirementsName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsName(String decisionRequirementsName) {
      this.decisionRequirementsName = decisionRequirementsName;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsVersion() decisionRequirementsVersion} attribute.
     * @param decisionRequirementsVersion The value for decisionRequirementsVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsVersion(int decisionRequirementsVersion) {
      this.decisionRequirementsVersion = decisionRequirementsVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
     * @param decisionRequirementsKey The value for decisionRequirementsKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsKey(long decisionRequirementsKey) {
      this.decisionRequirementsKey = decisionRequirementsKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getNamespace() namespace} attribute.
     * @param namespace The value for namespace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withNamespace(String namespace) {
      this.namespace = namespace;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getChecksum() checksum} attribute.
     * @param checksum The elements for checksum
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChecksum(byte... checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsRecordValue#getResource() resource} attribute.
     * @param resource The elements for resource
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResource(byte... resource) {
      this.resource = resource;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.decisionRequirementsId = null;
      this.decisionRequirementsName = null;
      this.decisionRequirementsVersion = 0;
      this.decisionRequirementsKey = 0;
      this.namespace = null;
      this.resourceName = null;
      this.checksum = null;
      this.duplicate = false;
      this.resource = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDecisionRequirementsRecordValue ImmutableDecisionRequirementsRecordValue}.
     * @return An immutable instance of DecisionRequirementsRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDecisionRequirementsRecordValue build() {
      return new ImmutableDecisionRequirementsRecordValue(
          decisionRequirementsId,
          decisionRequirementsName,
          decisionRequirementsVersion,
          decisionRequirementsKey,
          namespace,
          resourceName,
          checksum,
          duplicate,
          resource);
    }



  }



}
